---
title: yaml
description: FieldType YAML
weight: 242
---

Stores structured data in YAML format for configuration and serialized objects.

## dataformat: text

YAML fields are implemented as text fields with a special extension.

```yaml
  MYFIELD:
      dataformat: text
      dataformat_ext: yaml
```

## dataformat_ext

**Required**: `yaml`

The `dataformat_ext: yaml` specifies that the text field should be treated and displayed as YAML with syntax highlighting and validation.

## Examples

### Schema Definition

```yaml
- classname: _schema
  keyname: deployment
  config:
    dataformat: text
    dataformat_ext: yaml
    displayname: Deployment Configuration
```

### Instance Example

```yaml
- classname: deployment
  keyname: app_prod
  config: |
    version: "1.0"
    environment: production
    replicas: 3
    database:
      host: db.example.com
      port: 5432
      ssl: true
```

## Notes

- Full YAML syntax supported (objects, arrays, strings, numbers, booleans, null)
- Useful for configuration, manifests, or structured data
- Complementary to JSON for human-readable structured formats
- Can be queried and manipulated with YAML parsers
- Related to text and json field types
