---
title: Welcome to Cavaliba
layout: hextra-home
---

{{< hextra/hero-badge >}}
  <div class="hx:w-2 hx:h-2 hx:rounded-full hx:bg-primary-400"></div>
  <span>Free, open source, BSD 3-clause license</span>
  {{< icon name="arrow-circle-right" attributes="height=14" >}}
{{< /hextra/hero-badge >}}

<div class="hx:mt-6"><br></div>

<div class="hx:mt-6 hx:mb-6">
{{< hextra/hero-headline >}}
  One Web platform, your data, many tools.&nbsp;<br class="hx:sm:block hx:hidden" />
{{< /hextra/hero-headline >}}
A Web Asset Management Platform with applications included.
</div>

<div class="hx:mt-6"><br></div>

<div class="hx:mb-6">
{{< hextra/hero-button text="Get Started" link="docs" >}}
</div>

<div class="hx:mt-6"><br></div>



<div class="hx:mt-6"></div>

{{< hextra/feature-grid >}}

  {{< hextra/feature-card
    title="Asset Management"
    subtitle="Describe your assets, implement models and centralize your data. Stop inventories in spreadsheets."
  >}}


  {{< hextra/feature-card
    title="Web Platform"
    subtitle="Manage your data assets from a single powerful Web platform. Clean Web for your browser and eyes, responsive design for large and small devices. Automatically generated UI from your models, no code."
  >}}

  {{< hextra/feature-card
    title="Hosting and Sovereignty"
    subtitle="Sovereignty anyone? Host where you want: on-prem, in the cloud, on a desert island, on your laptop. No web dependency, no callback, no tracker, no ads. Everything is in the box. Extract all your data in standard file format at any time. GDPR friendly."
  >}}


  {{< hextra/feature-card
    title="Relationships to value"
    subtitle="Define relationships between data models, interconnect with existing sources. With good relationships, 1 + 1 = 3; business value is here."
  >}}


  {{< hextra/feature-card
    title="Applications ? Included."
    subtitle="Cavaliba comes with a set of included standard ITSM and small business applications, of course connected to the data model. Use provided applications for instant value."
  >}}
  

  {{< hextra/feature-card
    title="Open Source BSD. And free !"
    subtitle="3-clause open source BSD permissive license. Do what you want. We live and develop by providing support and professional services."
  >}}



  {{< hextra/feature-card
    title="Life changes. Be dynamic."
    subtitle="Dynamic Data Models by design. Models change. Update asset definitions at any time with immediate effect. Enforce constraints for data quality. Short-lived items are OK. Start small, use predefined models, edit and evolve over time. Or build from scratch."
  >}}


  {{< hextra/feature-card
    title="Security ?"
    subtitle="Authenticate locally, or with LDAP or SAML/OIDC federation. Users, Groups, Roles, and Permissions let you manage authorization at macro or granular level. Allow read access to large groups. Review/export logs. Deploy high-availability for resilience. Encrypt at rest. And more."
  >}}


  {{< hextra/feature-card
    title="Dataviews, Reporting and BI"
    subtitle="Create dataviews for most requested data subsets. Connect external BI tools like Tableau, Metabase, Superset or others to the Cavaliba Database for unlimited reporting."
  >}}

  {{< hextra/feature-card
    title="Interconnect"
    subtitle="Use the REST API to move/sync data between Cavaliba and existing systems. Be asynchronous with files like JSON, YAML to bulk import/export. Apply pipelines to transform. Use provided command-line tools (local, remote) if needed."
  >}}



  {{< hextra/feature-card
    title="Fast with large datasets"
    subtitle="Cavaliba is fast. With large datasets and complex data models, UI response time is immediate even on small virtual machines or modest container platforms. Tested with more than 500,000 objects per Asset Schema, or 50K+ user entries. Computationally intensive tasks are offloaded to async workers."
  >}}



  {{< hextra/feature-card
    title="Prerequisite ?  Docker."
    subtitle="Cavaliba is provided as a set of docker containers with no external dependency after startup. Run the provided docker-compose in minutes. You can also run Cavaliba natively as a regular modern Python/Django application. Thanks giants."
  >}}


{{< hextra/feature-card
    title="Pricing and support"
    subtitle="Cavaliba software is free with no community/premium model. Everything is included. See **Support** if you need professional services. We live on that."
  >}}


  {{< hextra/feature-card
    title="Taste of included applications ?"
    subtitle="Emergency notifications, CMDB, Status Page, IPAM. More to come, stay tuned."
  >}}


{{< /hextra/feature-grid >}}



<div class="hx:mt-6"><br></div>

