/*
Copyright © 2025 cavaliba.com
*/
package cmd

import (
	"fmt"
	"os"

	"cavpoller/poller"

	"github.com/spf13/cobra"
)

// worklistCmd represents the worklist command
var worklistCmd = &cobra.Command{
	Use:   "worklist",
	Short: "Retrieve and display worklist from Cavaliba server",
	Long:  `Retrieve and display worklist from Cavaliba server`,
	Run: func(cmd *cobra.Command, args []string) {
		worklist, err := poller.GetWorklist()
		if err != nil {
			fmt.Printf("Error: %v\n", err)
			os.Exit(1)
		}
		poller.PrintWorklist(worklist)
	},
}

func init() {
	rootCmd.AddCommand(worklistCmd)

	// Here you will define your flags and configuration settings.

	// Cobra supports Persistent Flags which will work for this command
	// and all subcommands, e.g.:
	// worklistCmd.PersistentFlags().String("foo", "", "A help for foo")

	// Cobra supports local flags which will only run when this command
	// is called directly, e.g.:
	// worklistCmd.Flags().BoolP("toggle", "t", false, "Help message for toggle")
}
