# Generated by Django 5.0.4 on 2025-02-12 16:50

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('app_user', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='CavalibaLog',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('app', models.CharField(blank=True, default='', max_length=200, verbose_name='App')),
                ('view', models.CharField(blank=True, default='', max_length=200, verbose_name='View')),
                ('action', models.CharField(blank=True, default='', max_length=200, verbose_name='Action')),
                ('status', models.CharField(blank=True, default='', max_length=32, verbose_name='Status')),
                ('data', models.CharField(default='', max_length=2000, verbose_name='data')),
                ('level', models.CharField(default='na', max_length=20, verbose_name='Level')),
                ('created', models.DateTimeField(auto_now_add=True, db_index=True)),
                ('username', models.CharField(default='na', max_length=256, verbose_name='Username')),
                ('user_ip', models.CharField(default='', max_length=64, verbose_name='User IP')),
                ('impersonate', models.CharField(default='na', max_length=256, verbose_name='Impersonate')),
            ],
            options={
                'verbose_name': 'Cavaliba Log',
                'verbose_name_plural': 'Cavaliba Logs',
                'ordering': ['created'],
            },
        ),
        migrations.CreateModel(
            name='CavalibaAPIStat',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('keyname', models.SlugField(max_length=128, unique=True, verbose_name='Keyname')),
                ('last_success', models.DateTimeField(blank=True, null=True, verbose_name='Last success')),
                ('last_error', models.DateTimeField(blank=True, null=True, verbose_name='Last error')),
                ('success_count', models.IntegerField(default=0, verbose_name='success count')),
                ('error_count', models.IntegerField(default=0, verbose_name='Error count')),
            ],
            options={
                'verbose_name': 'Cavaliba API Stat',
                'verbose_name_plural': 'Cavaliba API Stats',
                'indexes': [models.Index(fields=['keyname'], name='app_home_ca_keyname_6521bc_idx')],
            },
        ),
        migrations.CreateModel(
            name='CavalibaConfiguration',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('appname', models.SlugField(default='home', max_length=128, verbose_name='Cavaliba App')),
                ('keyname', models.SlugField(max_length=128, verbose_name='Keyname(*)')),
                ('value', models.CharField(blank=True, max_length=1500, null=True, verbose_name='Value')),
                ('description', models.CharField(blank=True, max_length=500, null=True, verbose_name='Description')),
                ('page', models.CharField(blank=True, default='', max_length=1500, verbose_name='Page')),
                ('order', models.IntegerField(default=100, verbose_name='Order')),
            ],
            options={
                'verbose_name': 'Cavaliba Configuration',
                'verbose_name_plural': 'Cavaliba Configurations',
                'ordering': ['appname', 'page', 'order', 'keyname'],
                'unique_together': {('appname', 'keyname')},
            },
        ),
        migrations.CreateModel(
            name='DashboardApp',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('keyname', models.SlugField(max_length=100, unique=True, verbose_name='Key name(*)')),
                ('displayname', models.CharField(blank=True, max_length=128, verbose_name='Display name')),
                ('description', models.CharField(blank=True, max_length=500, verbose_name='Description')),
                ('is_enabled', models.BooleanField(default=True, verbose_name='Enabled')),
                ('url', models.CharField(blank=True, default='', max_length=1500, verbose_name='URL')),
                ('icon', models.CharField(blank=True, default='', max_length=128, verbose_name='Icon')),
                ('sidebar_section', models.CharField(blank=True, default='', max_length=128, verbose_name='Sidebar section')),
                ('dashboard_section', models.CharField(blank=True, default='', max_length=128, verbose_name='Dashboard section')),
                ('order', models.IntegerField(default=100, verbose_name='Order')),
                ('permission', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='app_user.sirenepermission')),
            ],
            options={
                'verbose_name': 'Dashboard Application',
                'verbose_name_plural': 'Dashboard Applications',
                'db_table': 'app_home_dashboard_app',
                'ordering': ['order'],
            },
        ),
    ]
