# (c) cavaliba.com

#  create fake/test data
# python -m venv venv
# . ./venv/bin/activate
# pip install Faker PyYAML

# python ./script/fake_generator.py --user 1 --seed 123 --format json --locale fr_FR 
# python ./script/fake_generator.py --user 500 > files/demo/data/demo_user.yaml
# python ./script/fake_generator.py --user 500 --group > files/demo/data/demo_group.yaml
# python ./script/fake_generator.py --user 500 --app > files/demo/data/demo_app.yaml
# cavaliba load /files/demo/data/demo_user.yaml




import yaml
import json
import random 
import argparse 

from faker import Faker

# YAML export
class MyYamlDumper(yaml.SafeDumper):
    def write_line_break(self, data=None):
        super().write_line_break(data)
        if len(self.indents) < 2:
            super().write_line_break()


parser = argparse.ArgumentParser()
#parser.add_argument("schema", default="user", help="user group site app")
parser.add_argument('--seed', type=int, default=1, help="random seed to init")
parser.add_argument('--format', default='yaml', help="yaml json")
parser.add_argument('--user', type=int, default=0, help="number of USER (default 0)")
parser.add_argument('--group', type=int, default=0, help="number of GROUP (default 0)")
parser.add_argument('--app', type=int, default=0, help="number of APP (default 0)")
parser.add_argument('--site', type=int, default=0, help="number of SITE (default 0)")
parser.add_argument('--locale', default='', help="Language/Locale as fr_FR (default multi)")

parser.parse_args()
args = parser.parse_args()
#print(args.echo)

if args.locale:
    fake = Faker([args.locale])
else:
    fake = Faker(['it_IT', 'en_UK', 'fr_FR', 'es_ES', 'de_DE', 'pt_PT', 'nl_NL'])

Faker.seed(args.seed)


# _user
data_user = []
for i in range(args.user):
    user = {}
    user['classname'] = '_user'
    user['firstname'] = fake.first_name()
    user['lastname'] = fake.last_name()
    user['login'] = fake.unique.user_name()
    user['external_id'] = fake.bothify(text='??-######', letters='CAVALIBA')
    user['displayname'] = f"{user['firstname']} {user['lastname']}"
    user['email'] = f"{user['lastname']}@demo.cavaliba"
    user['mobile'] = fake.country_calling_code() + '-' + fake.msisdn()[0:8]
    user['description'] = f"User {user['displayname']} for cavaliba demo"
    user["is_enabled"] = fake.bothify(text='?', letters='00000000001') in ['0']
    #user["is_enabled"] = fake.random_choices(elements=(True, True, True, True, False), length=1)[0]
    user["want_notifications"] = fake.bothify(text='?', letters='0000001') in ['0']
    user["want_24"]  = fake.bothify(text='?', letters='01') in ['0']
    user["want_sms"] = fake.bothify(text='?', letters='0001') in ['0']
    user["want_email"]  = fake.bothify(text='?', letters='0000001') in ['0']
    data_user.append(user)

# group
data_group = []
for i in range(args.group):
    group = {}
    group['classname'] = '_group'
    group['keyname'] = fake.unique.bothify(text='g_????_##', letters='CAVALIBA')
    group['displayname'] = 'Group ' + group['keyname']
    group['description'] = f"{group['displayname']} for cavaliba demo"
    # users
    group['users'] = []
    for _ in range(random.randint(0,5)):
        try:
            u = random.choice(data_user)
            group['users'].append(u["login"])
        except:
            pass
    group['users'] = sorted(set(group["users"]))
    # subgroups
    group['members'] = []
    data_group.append(group)



# app 
# - classname: app
#   keyname: mail
#   displayname: Mail systems
#   description: Mail systems
#   sirene_group:
#     - g_app_mail
data_app = []
for _ in range(args.app):
    item = {}
    item['classname'] = 'app'
    item['keyname'] = fake.unique.bothify(text='app_?????', letters='ABCDEFGHIJKLMNOPQRSTUVWXYZ')
    item['displayname'] = 'APP ' + item['keyname']
    item['description'] = f"{item['displayname']} for cavaliba demo"
    data_app.append(item)



# site
# - classname: site
#   keyname: madrid02
#   displayname: HQ Madrid
#   description: Headquarters in Madrid
data_site = []
for _ in range(args.site):
    item = {}
    item['classname'] = 'site'
    item['keyname'] = fake.unique.bothify(text='site_##???', letters='ABCDEFGHIJKLMNOPQRSTUVWXYZ')
    item['displayname'] = 'SITE ' + item['keyname']
    item['description'] = f"{item['displayname']} for cavaliba demo"
    data_site.append(item)




# concat and output
data = data_user + data_group + data_app + data_site

if args.format == "yaml":
    output = yaml.dump(data, allow_unicode=True, Dumper=MyYamlDumper, sort_keys=False)

elif args.format == "json":
    output = json.dumps(data, indent=4, ensure_ascii = False)

print(output)


# my_word_list = [
# 'danish','cheesecake','sugar',
# 'Lollipop','wafer','Gummies',
# 'sesame','Jelly','beans',
# 'pie','bar','Ice','oat' ]
# fake.sentence()
# # 'Expedita at beatae voluptatibus nulla omnis.'
# fake.sentence(ext_word_list=my_word_list)
# # 'Oat beans oat Lollipop bar cheesecake.'



# medical_professions_provider = DynamicProvider(
#      provider_name="medical_profession",
#      elements=["dr.", "doctor", "nurse", "surgeon", "clerk"],
# )
# fake = Faker()
# # then add new provider to faker instance
# fake.add_provider(medical_professions_provider)
# # now you can use:
# fake.medical_profession()




# # first, import a similar Provider or use the default one
# from faker.providers import BaseProvider
# # create new provider class
# class MyProvider(BaseProvider):
#     def foo(self) -> str:
#         return 'bar'
# # then add new provider to faker instance
# fake.add_provider(MyProvider)
# # now you can use:
# fake.foo()









