---
title: group
description: FieldType Group
weight: 231
---

References one or more Cavaliba user groups. Allows linking data to user groups for team-based organization.

## dataformat: group

```yaml
  MYFIELD:
      dataformat: group
```

## dataformat_ext

**Not used** - Group fields have no extended options. The field automatically references all groups in the system.

## Values

Field contains group IDs as strings. References SireneGroup objects in the system.

## Multivalue

Multi-value is supported and commonly used.

```yaml
## SCHEMA
MYGROUPS:
      dataformat: group
      cardinal_max: 0

## INSTANCE multi-valued
  MYGROUPS: [admin, developers, testers]
```

## Examples

### Schema Definition

```yaml
- classname: _schema
  keyname: document
  shared_group:
    dataformat: group
    displayname: Shared With Group
    description: Group with access to document
```

### Instance Example

```yaml
- classname: document
  keyname: doc001
  shared_group: developers
```

## Relationship to Users

Groups contain users. When a group is referenced:
- All members of the group have associated permissions
- Notifications can be sent to all group members
- Access control can be based on group membership

## Notes

- References actual groups in the IAM system (SireneGroup model)
- Groups can contain multiple users
- Useful for team-based access control and notifications
- Related to authorization and permission management
- Can be used in conjunction with roles for granular access control
