# (c) cavaliba.com - tests / home / view

from django.test import override_settings
from django.test import TestCase
from django.test import TransactionTestCase
from django.urls import reverse
from django.core.cache import cache as cache_django

from tests import helper
import app_home.cache as cache


class IAMViews(TestCase):

    fixtures = ["init"]

    def setUp(self):
        helper.add_admin_user(login="unittest")
        cache.clear()
        cache_django.clear()

    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_admintools_access_with_permission(self):
        """Test admintools view is accessible with p_admintools permission"""
        response = self.client.get(reverse('app_home:admintools'), follow=True)
        self.assertEqual(response.status_code, 200)
        # Check that the response contains the DB Reset button
        self.assertContains(response, 'DB Reset', status_code=200)

    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_admintools_modal_present(self):
        """Test confirmation modal is present in the response"""
        response = self.client.get(reverse('app_home:admintools'), follow=True)
        self.assertEqual(response.status_code, 200)
        # Check for modal elements
        self.assertContains(response, 'factoryResetModal', status_code=200)
        self.assertContains(response, 'Confirm Factory Reset', status_code=200)

    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_admintools_csrf_token_in_modal_form(self):
        """Test CSRF token is present in the modal form"""
        response = self.client.get(reverse('app_home:admintools'), follow=True)
        self.assertEqual(response.status_code, 200)
        # Check for CSRF token in the modal's form
        self.assertContains(response, 'csrfmiddlewaretoken', status_code=200)

    def test_admintools_non_admin_user_denied(self):
        """Test non-admin user is denied access to admintools"""
        # Create a regular user without admin role
        response = self.client.get(reverse('app_home:admintools'), follow=True)
        self.assertEqual(response.status_code, 200)
        self.assertNotContains(response, 'factoryResetModal', status_code=200)
        self.assertNotContains(response, 'Admin tools', status_code=200)

    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_admintools_revision_access_with_permission(self):
        """Test admintools_revision view is accessible with p_admintools permission"""
        response = self.client.get(reverse('app_home:admintools_revision'), follow=True)
        self.assertEqual(response.status_code, 200)
        # Check for revision page content
        self.assertContains(response, 'Data Revisions', status_code=200)
        # When no revisions exist, check for the empty message
        self.assertContains(response, 'No more revision entries found', status_code=200)

    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_admintools_revision_button_in_admintools_page(self):
        """Test revision button is present in admintools page when allowed"""
        response = self.client.get(reverse('app_home:admintools'), follow=True)
        self.assertEqual(response.status_code, 200)
        # Check for Revision button
        self.assertContains(response, 'Revision', status_code=200)
        # Check for the button URL
        self.assertContains(response, reverse('app_home:admintools_revision'), status_code=200)
        # Check for description
        self.assertContains(response, 'View and manage data revision tracking and history', status_code=200)

    def test_admintools_revision_non_admin_user_denied(self):
        """Test non-admin user is denied access to admintools_revision"""
        response = self.client.get(reverse('app_home:admintools_revision'), follow=True)
        # Should be redirected, not allowed
        self.assertEqual(response.status_code, 200)
        # Should not contain revision page content
        self.assertNotContains(response, 'Data Revisions', status_code=200)

