# (c) cavaliba.com


from io import StringIO
# import io

from django.test import override_settings
from django.test import TestCase
from django.test import TransactionTestCase
from django.urls import reverse
from django.core.cache import cache as cache_django
from django.core.management import call_command

from tests import helper

import app_home.cache as cache


class CommandTest(TestCase):

    fixtures = ["test"]

    def setUp(self):
        cache.clear()

    def test_check_command(self):

        output = StringIO()
        StringIO()
        call_command("check", verbosity=2, stdout=output)
        assert ("System check identified no issues" in output.getvalue())

    def test_version_command(self):
        output = StringIO()
        StringIO()
        call_command("cavaliba", "version", verbosity=2, stdout=output)
        assert ("." in output.getvalue())
        self.assertTrue(len(output.getvalue()) > 5)

    def test_init_command(self):
        output = StringIO()
        StringIO()
        call_command("cavaliba", "init", verbosity=2, stdout=output)
        assert ("init done" in output.getvalue())

    def test_schema_command(self):
        output = StringIO()
        StringIO()
        call_command("cavaliba", "schema", verbosity=2, stdout=output)
        assert ("IAM" in output.getvalue())

    def test_get_command(self):
        output = StringIO()
        StringIO()
        call_command("cavaliba",
                     "get",
                     "--schema",
                     "test1",
                     "--yaml",
                     verbosity=2, stdout=output)
        assert ("keyname: test1-01" in output.getvalue())

    def test_conf_command(self):

        output = StringIO()
        StringIO()
        call_command("cavaliba", "conf", verbosity=2, stdout=output)
        assert ("GLOBAL_APPNAME" in output.getvalue())

    def test_log_command(self):
        output = StringIO()
        StringIO()
        call_command("cavaliba", "log", verbosity=2, stdout=output)
        assert ("entries" in output.getvalue())

    def test_log_purge_command(self):

        output = StringIO()
        StringIO()
        call_command(
            "cavaliba",
            "log",
            "--log_purge",
            verbosity=2,
            stdout=output)
        assert ("log done" in output.getvalue())

    def test_load_command_unknown(self):

        output = StringIO()
        err = StringIO()
        call_command(
            "cavaliba",
            "load",
            "unknown_file",
            verbosity=2,
            stdout=output,
            stderr=err)
        assert ("load done" in output.getvalue())
        assert ("SKIP - Unknown filename" in err.getvalue())
