# app_user - permission_views.py
# (c) cavaliba.com 

import os
from datetime import datetime, timedelta


from django.shortcuts import render, redirect
from django.utils.translation import gettext as _

from app_home.log import log, DEBUG, INFO, WARNING, ERROR, CRITICAL

from .aaa import start_view

from .permission import permission_get_all




# ----------------------------------------------------------
# PERMISSION list
# ----------------------------------------------------------    
def list(request):
    '''  display permission list'''

    context = start_view(request, app="iam", view="permission_list", noauth="app_home:index", 
        perm="p_permission_read", noauthz="app_sirene:index")
    if context["redirect"]:
        return redirect(context["redirect"])
    aaa = context["aaa"]
   

    count = 0
    permissions = permission_get_all()
    count = len(permissions)

    log(DEBUG, aaa=aaa, app="iam", view="permission_list", action="get", status="OK", data=f"{count} permissions")

    context["count"] = count
    context["permissions"] = permissions
    return render(request, 'app_user/permission_list.html', context)
