# (c) cavaliba.com  - status - api.py

import json

from django.http import HttpResponse
from django.views.decorators.csrf import csrf_exempt



from app_user.aaa_api import start_api

# from app_data.data import get_classes
# from app_data.data import get_instances
# from app_data.data import Instance

from app_status.common import get_monitors
from app_status.common import get_monitor_names
from app_status.models import StatusRaw

#   ----------------------------------------------------------------------------
# /appstatus/api/
#   ----------------------------------------------------------------------------
# worklist/        GET  =>
# monitor/XXXX     GET  => ratio(s)
#                  POST => result OK/KO


#   ----------------------------------------------------------------------------
# start_view
#   ----------------------------------------------------------------------------

# context = start_api(request)


# context = {}
# context["is_allowed"] = False
# context["keyname"] = None
# context["is_readonly"] = True
# context["error"] = "no action performed"
# context["user_ip"] = None
# context["acl_filter"] = None
# context["permissions"] = []


#   ----------------------------------------------------------------------------
# GET worklist/
#   ----------------------------------------------------------------------------
@csrf_exempt
def worklist(request):

    context = start_api(request)

    if not context["is_allowed"]:
        e = context['error']
        error = {"status": "KO", "error": f"{e}"}
        myjson = json.dumps(error, ensure_ascii=False).encode('utf8')
        return HttpResponse(myjson, status=401)    # unauthorized

    if request.method != "GET":
        error = {"status": "KO", "error": "invalid method"}
        myjson = json.dumps(error, ensure_ascii=False).encode('utf8')
        return HttpResponse(myjson, status=401)    # unauthorized

    if "p_status_worklist" not in context["permissions"]:
        error = {"status": "KO", "error": "not allowed"}
        myjson = json.dumps(error, ensure_ascii=False).encode('utf8')
        return HttpResponse(myjson, status=401)    # unauthorized


    mlist = get_monitors()
    monitors = []

    for m in mlist:
        item = {}
        item["keyname"] = m.keyname
        item["displayname"] = m.displayname
        item["type"] = m.type
        item["is_enabled"] = m.is_enabled
        item["timeout"] = m.timeout
        if m.type == "HTTP":
            item["target"] = m.target
            item["http_code"] = m.http_code
            item["http_ssl_verify"] = m.http_ssl_verify
            item["http_allow_redirect"] = m.http_allow_redirect
            item["http_pattern"] = m.pattern
            item["http_pattern_reject"] = m.pattern_reject

        monitors.append(item)


    reply = {
        "status": "OK",
        "monitors": monitors
        }
    myjson = json.dumps(reply, ensure_ascii=False).encode('utf8')
    return HttpResponse(myjson)


#   ----------------------------------------------------------------------------
# POST workresult/
#   ----------------------------------------------------------------------------
@csrf_exempt
def workresult(request):

    context = start_api(request)

    if not context["is_allowed"]:
        e = context['error']
        error = {"status": "KO", "error": f"{e}"}
        myjson = json.dumps(error, ensure_ascii=False).encode('utf8')
        return HttpResponse(myjson, status=401)    # unauthorized

    if request.method != "POST":
        error = {"status": "KO", "error": "invalid method"}
        myjson = json.dumps(error, ensure_ascii=False).encode('utf8')
        return HttpResponse(myjson, status=401)    # unauthorized

    if "p_status_workresult" not in context["permissions"]:
        error = {"status": "KO", "error": "not allowed"}
        myjson = json.dumps(error, ensure_ascii=False).encode('utf8')
        return HttpResponse(myjson, status=401)    # unauthorized

    results = json.loads(request.body)
    monitor_names = get_monitor_names()

    for result in results:

        monitor = result.get('monitor', None)
        if monitor not in monitor_names:
            error = {"status": "KO", "error": "invalid monitor"}
            myjson = json.dumps(error, ensure_ascii=False).encode('utf8')
            return HttpResponse(myjson, status=404)    # not found

        obj = StatusRaw()
        obj.monitor = monitor
        if result['status'] == "OK":
            obj.status = True
            obj.data = ""
        else:
            obj.status = False
            obj.data = result.get('error', '')
        obj.usec = int(result.get('usec', 0))
        obj.save()


    reply = {
        "status": "OK",
        }
    myjson = json.dumps(reply, ensure_ascii=False).encode('utf8')
    return HttpResponse(myjson)

