# (c) cavaliba.com - data - urls_api.py

from django.urls import path

from app_data import api

# url namespace
app_name="api"


# first match is used
urlpatterns = [

    # ping / no auth
    path('', api.ping.index, name='api'),   
    path('ping/', api.ping.ping, name='api_ping'),

    # test
    path('test/', api.testapi.testapi, name='api_test'),
    
    path('version/', api.version.version, name='api_version'),
    path('info/', api.info.info, name='api_info'),
    
    # schemas
    path('schemas/', api.schema.schema, name='api_schema'),
    path('schemas/<str:skey>/', api.schema.schema, name='api_schema'),

    # user
    path('users/', api.user.user, name='api_user'),
    path('users/<int:id>/', api.user.user, name='api_user'),
    path('users/<str:key>/', api.user.user, name='api_user'),

    # assets
    path('assets/', api.asset.asset, name='api_asset'),
    path('assets/<int:id>/', api.asset.asset, name='api_asset'),
    path('assets/<str:skey>/', api.asset.asset, name='api_asset'),
    path('assets/<str:skey>/<str:key>/', api.asset.asset, name='api_asset'),

    # import 
    path('import/', api.importer.index, name='api_import'),

    # user
    # group
    # role
    # permission
    # sirene
    # ipam
    # revision
    # status
    # speed
    # log
    # stats
    # admintools
]