---
title: API
description: API Framework
weight: 90
draft: false
---


# URLs

The `api` endpoint is /api/.

Example:

    curl -v http://localhost/api/ping/



# Authentication

Each call to the API must provide a valid API Key.

API Keys are created in the User Interface (sidebar / API Key), with a short keyname and a secret.

Remember to use HTTPS when publishing Cavaliba.



# Permission model

Each API Key has a set of permissions. 

These permissions are configured in the ACL Text Field of each API Key. 

You provide a list of permissions which are concatenated. You can use a `!` to remove (negate) a set of permissions.

Example:

    ## ACL

    p_info
    p_data_site_read
    p_data_app_read
    !p_data_app_read
    role:role_test01          


## Special

* special authorization : timerange, IP range



# cavctl

CAVCTL is a standalone executable that wraps calls to the API with a human-friendly CLI.

See the dedicated page.



# Endpoints

* /api/ping/
* /api/version/
* /api/info/
* /api/users/
* /api/schemas/
* /api/assets/


# Options

* o=[json|yaml|txt]
* id=<INT>
* schema=SCHEMA_NAME
* page=<int>
* size=<int>
* search=SEARCH_PATTERN



# Examples

    curl http://localhost/api/
    curl -v http://localhost/api/


    curl http://localhost/api/ping/


    curl -H "X-Cavaliba-Key: test a_secret_key" http://localhost/api/version/
    

    curl -H "X-Cavaliba-Key: test a_secret_key" http://localhost/api/info/


    curl -H "X-Cavaliba-Key: test a_secret_key" \
        http://localhost/api/assets/?search=anc&page=1&size=10&o=json



    curl  -XPOST  \
        -H "X-Cavaliba-Key: key1 ktest1" \
        -H 'Content-Type: text/x-yaml' \
        -H 'Accept: application/json'  \
        http://localhost/api/import/ \
        --data-binary @/tmp/test.yaml

    curl -XPOST \
        -H "X-Cavaliba-Key: key1 ktest1"  \
        -H 'Content-Type: application/json' \
        -H 'Accept: application/json'  \
        http://localhost/api/import/ \
        --data-binary @/tmp/test.json


    curl -XPOST -H "X-Cavaliba-Key: key1 ktest1" \
        --header "Content-Type: text/csv" \
        --data-binary "@/tmp/test.csv" \
        "http://localhost/api/csv/?pipeline=pipe0&delimiter=,"




# Web configuration

You may check your current nginx.conf. If you've upgrade Cavaliba from an old version (3.26 and earlier), you need to add the proper location as described here. You may download a newer release to see a complete configuration.


The key point is to make the /api/ endpoint available without OAUTH2 or other Basic Authentication scheme. API Authentication is based on headers and shared secrets.


    # -----------------------
    # cavaliba api
    # -----------------------

    location /api/ {
    
        # no SAM/OIDC/OAUTH2 authentication
        # no middleware authentication (Basic Auth / Digest)

        # for API / file upload:
        client_max_body_size 20M;

        proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
        proxy_set_header Host $host;
        real_ip_header X-Real-IP;
        #proxy_set_header X-Real-IP $remote_addr;
        proxy_redirect off;
        proxy_http_version 1.1;

        proxy_pass http://cavaliba_app;

        }
