---
title: ipv4
description: FieldType IPv4
weight: 220
---

Represents an IPv4 address (Internet Protocol version 4).

## dataformat: ipv4

```yaml
  MYFIELD:
      dataformat: ipv4
      default: "192.168.1.1"
```

## dataformat_ext

**Not used** - IPv4 fields have no extended options. Standard dotted decimal notation (A.B.C.D) is always used.

## Format

IPv4 addresses are stored in standard dotted decimal notation: **A.B.C.D** where each component (A, B, C, D) is 0-255.

Examples:
- 192.168.1.1
- 10.0.0.50
- 8.8.8.8
- 127.0.0.1

## Multivalue

Multi-value is supported for storing multiple IP addresses.

```yaml
## SCHEMA
MYSERVERS:
      dataformat: ipv4
      cardinal_max: 0

## INSTANCE multi-valued
  MYSERVERS: [192.168.1.10, 192.168.1.11, 192.168.1.12]
```

## Examples

### Schema Definition

```yaml
- classname: _schema
  keyname: server
  ip_address:
    dataformat: ipv4
    displayname: IP Address
    description: Server IPv4 address
```

### Instance Example

```yaml
- classname: server
  keyname: web01
  ip_address: "192.168.1.100"
```

## Notes

- IPv4 addresses only (use external field type for IPv6 if needed)
- Validation ensures proper IPv4 format
- Useful for network management, IPAM systems, and infrastructure documentation
- Can be filtered and searched in data views
- Related to the `app_ipam` module for comprehensive IP management
