---
title: int
description: FieldType Int
weight: 221
---

Represents an integer value.

## dataformat: int

```yaml
  MYFIELD:
      dataformat: int
      dataformat_ext: [gt_#|gte_#|lt_#|lte_#]
      default: 144
```

## dataformat_ext

Optional **dataformat_ext** can be a combination of:
- gt_123 : greater than 123
- gte_123: greater or equal than 123
- lt_100: lesser than 100
- lte_100: lesser or equal than 100

## Multivalue

Multi-value is supported.

```yaml
## SCHEMA
MYFIELDMULTI:
      dataformat: int
      cardinal_max: 0

## INSTANCE multi-valued
  MYFIELDMULTI: [12,15,-567]
  # or
  MYFIELDMULTI: '145 234 -789'
```

## Examples

### Schema Definition

```yaml
- classname: _schema
  keyname: project
  workforce_allocated:
    displayname: Workforce allocated (man.days)
    dataformat: int
    dataformat_ext: gte_0 lte_500
    description: "constraint: integer value in [0, 500]"
```

### Instance Example

```yaml
- classname: project
  keyname: project01
  workforce_allocated: 123
```
