---
title: date
description: FieldType Date
weight: 214
---

Represents a date value (year, month, day) without time information.

## dataformat: date

```yaml
  MYFIELD:
      dataformat: date
      default: "2025-01-01"
```

## dataformat_ext

**Not used** - Date fields have no extended options. ISO 8601 format (YYYY-MM-DD) is always used.

## Format

Dates are stored and displayed in ISO 8601 format: **YYYY-MM-DD**

Examples:
- 2025-01-15
- 2024-12-31
- 1999-06-20

## Multivalue

Multi-value is supported for storing multiple dates.

```yaml
## SCHEMA
MYHOLIDAYS:
      dataformat: date
      cardinal_max: 0

## INSTANCE multi-valued
  MYHOLIDAYS: [2025-01-01, 2025-12-25]
```

## Examples

### Schema Definition

```yaml
- classname: _schema
  keyname: event
  event_date:
    dataformat: date
    displayname: Event Date
    description: Date when event occurs
```

### Instance Example

```yaml
- classname: event
  keyname: conference2025
  event_date: "2025-06-15"
```

## Notes

- Date picker widget provided in edit forms
- ISO 8601 format (YYYY-MM-DD) is used for storage and export
- Dates can be filtered and sorted in data views
- No timezone information (date only, not datetime)
