---
title: Assets and Schemas
description: 
weight: 30
draft: false
---


Cavaliba is mostly a software solution to manage real life Assets0. 

Asset definition and modeling is done with **Schemas** and **Fields**.

Individual objects are calles **Instances** or sometimes just Objects.


## First Schema : Site

Let's create a first schema to define healthcare centers for our fictional CavCorp company.

Go to the Import UI tool from the sidebar.

Paste the minimalistic code, check and import.

```yaml
- classname: _schema
  keyname: site
  displayname: Sites
```

This code says : create a new schema, named `site`, with a human-friendly title `Sites`.

Now go to the Asset Management menu entry, click on Other. You'll see your new / empty data model for Sites.

![First Schema](first_schema.png)

We didn't define a nice logo for our Site schema, so we see an ugly question mark symbol instead. Maybe we'd like a Site shortcut in the sidebar?

Let's fix that.

Copy, check, and save the modified code in the UI Import tool.

You should see the shortcut in the sidebar.

![Shortcut](schema_shortcut.png)

Several things to note:
- You can provide several objects in one import step
- The `_option` entry in the Site schema sets a nice icon for the schema (from the Font Awesome public list)
- A description built-in field was added to the Site schema
- A (large) `_home` object was added, named `data_site`; it creates shortcuts in the page and position specified. More about that in a later part of the tutorial.

You now have a handy shortcut in the sidebar, and a nice looking icon for your Site. It's time to add a first Site object.


## First clinic

Let's add a first healthcare facility. As always, either click on the Site Asset and fill the form, or use small code from the UI:

```yaml
- classname: site
  keyname: MADRD
  displayname: Madrid Orthopedic Clinic
  city: Madrid
  address: 11 Calle Gran Via
```

You should now see the first site in the Site asset.

![First Site](first_site.png)


## Rich Schema

From now on, you'll walk your way toward a more complete Schema for Site (Clinic) objects.

Let's add postal address information and basic info to our schema. Copy, check, and save as always in the UI Import tool. 

```yaml
- classname: _schema
  keyname: site
  _options:
      icon: fa-hospital-o 

  address:
     dataformat: string
     displayname: Address

  city:
     dataformat: string
     displayname: City

  zip:
     dataformat: string
     displayname: ZipCode

  country:
     dataformat: string
     displayname: Country code

  head_count:
     dataformat: int
     displayname: Employees

  bed:
     dataformat: int
     displayname: Bed

  doctor:
     dataformat: int
     displayname: Medical doctors

```

You can now edit the Madrid clinic from the UI and observe the new fields immediately available.

You don't have to repeat `_options` or previous parameters (or fields) for the schema, because without specific instruction, schema definitions are updated (added) to the existing ones. 

![postal](site_postal.png)


## Sections

The blue header `Data` in the detailed view of your object is a section. Sections help organize large schemas. A table of contents (TOC) on the right side of the screen provides fast access to sections.

Let's separate our first fields into two sections: postal address and key numbers.

Click on Action and select Code. You'll be directly in the Import UI field with the schema code. Update with the following information. Check, save, and get back to the detailed view of your first clinic.


```yaml
- classname: _schema
  keyname: site
  _options:
      icon: fa-hospital-o 

  address:
     dataformat: string
     displayname: Address
     page: Postal Address
     order: 110

  city:
     dataformat: string
     displayname: City
     page: Postal Address
     order: 108

  zip:
     dataformat: string
     displayname: ZipCode
     page: Postal Address
     order: 106

  country:
     dataformat: string
     displayname: Country code
     page: Postal Address
     order: 104

  # Key infos

  head_count:
     dataformat: int
     displayname: Employees
     page: Key infos
     order: 200

  bed:
     dataformat: int
     displayname: Bed
     page: Key infos
     order: 210

  doctor:
     dataformat: int
     displayname: Medical doctors
     page: Key infos
     order: 204

```


![section](section_toc.png)

Observe the new headers, and the navigation bar on the right (TOC /  table of content ).

All fields are ordered with respect to the order value first, than the page name.


## More data Types

Cavaliba provides more than string or integer fields.

Let's add a URL field for the public website of your clinic.

Here, the `dataformat_ext` modifier instructs Cavaliba that the content of the field is a URL. It will be a hyperlink in the UI.

Most field types have `dataformat_ext` options. Text fields can be forced to Markdown, JSON, HTML, or YAML. Integer fields can have constraints, etc.


```yaml
- classname: _schema
  keyname: site
  _options:
      icon: fa-hospital-o 

  website:
     dataformat: string
     dataformat_ext: url
     displayname: Website
     page: Contact
     order: 300
```


For example, we may require that bed count be greater than zero like this:

```yaml
  bed:
     dataformat: int
     dataformat_ext: gte_0
     displayname: Bed
     page: Key infos
     order: 210
``` 


## Full Schema and demo data

Let's update our Site schema with a few simple fields, and bulk load the demo data provided with Cavaliba.

```yaml
- classname: _schema
  keyname: site
  displayname: Sites

  _options:
    icon: fa-hospital-o
    keyname_mode: edit
    keyname_label: Keyname
    displayname_label: Displayname

  # --- Postal Address

  country:
    displayname: Country code
    description: Country code
    dataformat: string
    order: 104
    page: Postal Address

  zip:
    displayname: ZipCode
    description: ZipCode
    dataformat: string
    order: 106
    page: Postal Address

  city:
    displayname: City
    description: City
    dataformat: string
    order: 108
    page: Postal Address

  address:
    displayname: Address
    description: Address
    dataformat: string
    order: 110
    page: Postal Address

  # --- Key infos

  head_count:
    displayname: Employees
    description: Employees
    dataformat: int
    order: 200
    page: Key infos

  doctor:
    displayname: Medical doctors
    description: Medical doctors
    dataformat: int
    order: 204
    page: Key infos

  bed:
    displayname: Bed
    description: Beds
    dataformat: int
    dataformat_ext: gte_0
    order: 210
    page: Key infos

  # -- contact

  website:
     dataformat: string
     dataformat_ext: url
     displayname: Website
     page: Contact
     order: 300

  email:
     dataformat: string
     displayname: Email
     page: Contact
     order: 310

  phone:
     dataformat: string
     displayname: Phone
     page: Contact
     order: 320
```


And bulk load demo data:

```bash
cavaliba load builtin/demo/20_site.yaml
``` 


![Sites](sites_list.png)


## Sites instances

A complete Site will have this code:

```yaml

- classname: site
  keyname: MADRD
  displayname: Madrid Orthopedic Clinic
  description: Orthopedic surgery leader
  country: ES
  address: 11 Calle Gran Via
  city: Madrid
  zip: 28013
  head_count: 200
  bed: 120
  doctor: 48
  phone: +34 91 1234567
  website: https://www.madrdortho.es
  email: consultas@madrdortho.es
```



## Dataviews

You might want to have immediate relevant information in the UI when accessing the Site list. This is what Dataviews are for. Dataviews let you define subset of Schema data that you can display in one click.

Create the following object either from Import or from the dataview menu in the sidebar:

```yaml
- classname: _dataview
  keyname: site_address
  target_class: site
  displayname: Address
  description: This View displays Address information about sites
  content: |
    columns:
      - Site ID:
          from: keyname
      - Name:
          from: displayname
      - city
      - Address:
          from: address 
      - Zip Code:
           from: zip
      - country
```         

Check the list view for the Site schema.

![Dataview](site_dataview.png)

You can now select a dataview and have all contact information on your screen. You can define many dataviews per schema and a `default_dataview`. When using Export from the action menu, you can choose to use a dataview subset.


Load demo data if needed (more dataviews included)

```bash
cavaliba load builtin/demo/21_site_dataview.yaml
``` 


## What's Next?

In Part 4, you'll learn about more advanced field types, like Enumerate and relationships between schemas. 




