# (c) cavaliba.com  - data/api - version.py

import json


from django.http import HttpResponse
from django.views.decorators.csrf import csrf_exempt, csrf_protect

from django.utils.translation import gettext as _

from app_home.log import log, DEBUG, INFO, WARNING, ERROR, CRITICAL
from app_home.configuration import get_configuration
from app_home.cavaliba import CAVALIBA_VERSION

from app_user.aaa_api import start_api

from .helper import send_denied
from .helper import send_response



# permission: p_info

#  ----------------------------------------------------------------------------
# /api/version/
#  ----------------------------------------------------------------------------
@csrf_exempt
def version(request):

    aaa_api = start_api(request, permission="p_info")
    if not aaa_api["is_allowed"]:
        return send_denied()

    log(DEBUG, aaa=aaa_api, app="api", view="version", action="GET", status="OK", data="")

    reply = {"version":CAVALIBA_VERSION}   
    return send_response(request, reply, 200)

