---
title: Field and Types
description: Field and types
weight: 202
---

Schemas have fields. Fields define attribute or properties of asset families.
When you design a Schema for an asset familiy, you must decide what fields to create to describe your asset families.



Example:

```yaml
- classname: _schema
  keyname: laptop

  brand:
    dataformat: string

  cpu:
    dataformat: int
```

Here, `brand` and `cpu` are fields for the `laptop` schema. They define what a laptop is.


Fields can be added/removed later, during the lifetime of a schema.

For example, you decide that a laptop asset should have a disk size field. You can upload the following definition which will add this field to the Data model for laptops, as well as the UI, REST API, etc.

```yaml
- classname: _schema
  keyname: laptop

  disk_size_gb:
    dataformat: int
    dataformat_ext: gte_0
    description: Disk Size in GB
```

You can now edit/uptade existing object to provide this additional information.


## Field format reference


```yaml
- classname: _schema
  keyname: (...)

  FIELDNAME:
      dataformat: FIELDTYPE             // int|float|...
      dataformat_ext:  OPTIONS          // optional, depends on selected FIELDTYPE
      displayname: A_NICE_FIELDNAME     // optional
      description: Hint for Humans      // optional
      cardinal_min: INT                 // optional (default 0)
      cardinal_max: INT                 // optional (default 1)
      page: MYPAGE                      // optional
      order: INT                        // optional
      default: A_VALUE                  // optional

   OTHER_FIELDNAME:
   (...)

```

where:

- **FIELDNAME** is the name of the field in the database
- **displayname** is a user-friendly name for humans
- **description** is a user-friendly line of text provided in the UI to assist users
- **dataformat** is the main Field TYpe for this field. See below
- **dataformat_ext**  provides additional information to the dataformat, such as constraints or parameters.
- **cardinal_min** defines the minimum number of mandatory values. 0 means the field is optional. Default is 0.
- **cardinal_max** defines the maximum number of accepted values. 0 means no limit (multi-valued), 1 means at most one value (single-valued field). Default is 1.
- **default** - default value if none provided at creation time (UI, API, import)


## Field Types

The available Field Types are described extensively in the next section.
