## (c) CAVALIBA.COM

###  Version

    2025/12 - 3.27.4

### Getting (quick) started

    cp env.template .env
    => customize .env (passwords, etc.)

    docker compose up -d
    
    => point your browser to http://localhost[:port]
    => login with admin and .env defined password

### Doc

    see www.cavaliba.com

### LICENSE

    BSD-3 CLAUSE


### 3.27.4

    - fix: missing displayname if none defined for notifications
    - /api/import/ + cavctl wrapper for import
    - fix: raised data or file upload to 50MB (before config option)


### 3.27.3

    - API: assets, schemas ; paginate, expand, yaml/json, search



### 3.27.2

    - fix: perms keyname caching



### 3.27.1

    - fix: notify_sitegroup missing debug info

### 3.27.0

    - API Framework refactor + version/info/schema
    - golang cavctl CLI client
    - fix: email html template outlook compatibility
    - fix: sirene notify_to generic behavior

    IMPORTANT: Update nginx.conf to allow /api/ directly
    
    # -----------------------
    # cavaliba api
    # -----------------------

    location /api/ {
    
        # for API / file upload:
        client_max_body_size 20M;

        # BEWARE mandatory !!!!
        proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
        proxy_set_header Host $host;
        real_ip_header X-Real-IP;
        #proxy_set_header X-Real-IP $remote_addr;
        proxy_redirect off;
        proxy_http_version 1.1;

        proxy_pass http://cavaliba_app;

        }


### 3.26.0

    - app sirene UI REFACTOR: sms_content, email templating, recipient count preview, 
    - new EMAIL_MESSAGE_TEMPLATE sirene configuration item (default=default)
    - fix: cache invalidation for instance by id vs by keyname 
    - fix revision_purge() aaa parameter in housekeeping task

### 3.25.1

    - env option CAVALIBA_INIT_CONTENT: empty, default, demo
    - refactor load_schema() 
    - simplied permissions p_schema_read / p_schema_write for all schema and field definitions
    - fix: dasboard icon default to keyname if empty displayname
    - fix: user yaml export : missing is_enabled = false if not enabled
    - fix: replaced 0xao space by regular space
    - fix: hide keyname in sirene_message / sirene_templates
    - fix ListView : use keyname_label, displayname_label
    - fix: related: filter unwanted schema and unauthorized schema (schema level)
    - fix: description is not a reserved field in DataInstance
    - fix: missing SMS / EMAIL Stats in sidebar (in default mode)


### 3.25.0

    - UI Group Detail : copy emails to clipboard
    - UI export view : compact and copy to clipboard
    - UI detail : TOC right with  scrollable main content
    - UI detail : related objects folded + popup
    - fix: typo in CAVALIBA_TIME_ZONE config in env.template file; missing quote
    - fix: docker-compose template : missing restart always for redis
    - fix: docker-compose  mariadb default as root, health check as root
    - fix: missing translation
    - split builtin/init,default,demo,tuto

### 3.24.1
    
    - fix: dev/prod python requirement mismatch (debug toolbar)


### 3.24.0

    - fix: no save/update_eav only in eav_refresh()
    - admintools page
    - refactor classobj, schema2 from DataInstance
    - removed deprecated get_classes()
    - admin tools : DataRevision display
    - pipeline primitive align_subnet4(cond, field)
    - pipeline primitive field_join(cond, sep, field, f1, f2, ...)
    - use natural-foreign for DataInstance, Field, Schema
    - fix: ipam missing check on unkown IP
    - exporter script / viewer

### 3.23.1

    - FIX: yaml text editor missing content/fields
    - FEATURE: pipeline primitive field_md5()
    - unittest refactor
    - removed old get_schema() function
    - separate dockerfile for dev & for prod
    - demo data to builtin/demo/


### 3.23.0

    - feature: data revision for objects
    - feature: FieldString URL support with dataformat_ext=url
    - fix (perf): cache autogroup users for aaa/permissions check
    - nicer UI for group detail 
    - unittest yaml external data
    - renamed DB model tables
    


### 3.22.0

    - feature: autogroup ; grammar G1/G2 for dynamic groups
    - user, group and role views switch to id parameter only
    - fix: empty blank in new TextField

### 3.21.1

    - fix: query user by email with invalid email during import


### 3.21.0

    - fix: group/role detail : missing description
    - fix: detail string multiple join()
    - fix: supress user in ajax UI
    - SIDEBAR_ENV and SIDEBAR_COLOR options for visual env hint
    - new FieldType: role
    - added role field to APIKey schema
    - removed handle
    - APIKEY  update APIKey permissions with individual permissions  (+ !negate)
    - API: /home/api/version/ + unittest
    - included cavpoller GO source code
    - included cavctl GO source code
    - docker env options : CAVALIBA_LANGUAGE_CODE="en-us" / CAVALIBA_TIME_ZONE="Europe/Paris
    - removed size limit of data instance content (json bloc)
    - sirene archive : reopen button
    - group detail includes a detailled user table (direct/indirect)
    - user ajax filter includes firstname, lastname, displayname
    - user lookup by email in import


    edit .env (see 3.21.0 env.template)
    # ----------------------------------------
    # Internationalization
    # ----------------------------------------
    CAVALIBA_LANGUAGE_CODE="en-us"
    CAVALIBA_TIME_ZONE="Europe/Paris


### 3.20.1 - minor bugfix

    - bugfix: builtin/  _action to init only
    - bugfix: target Sirene : invalid loop
    - bugfix : CSV import emptry group

    Upgrade Operations:
    - backup DB, CONF, and DATA
    - edit .env : version = 3.20.1
    - docker compose down
    - docker compose up -d

    Upgrade From: >= 3.19.0


### 3.20.0

    - bugfix: schema to_yaml missing description for fields
    - bugfix: separate multivalue with comma in Print view
    - bugfix: UI edit YAML label
    - bugfix: UI display field description
    - bugfix: missing mobile in UI user detail
    - bugfix: sirene missing template in message detail
    - bugfix: sirene missing retired_by in archived message
    - bugfix: boolean default value stored as bool instead of string
    - sirene: Category $C$, Severity $S$ placeholder in prefix/title/content
    - sirene: SMS with textified (html2text) full message content
    - sirene: display targets in sirene_message details
    - builtin yaml uses _action
    - UI CSV Import

    Upgrade Operations:
    - backup DB, CONF,  and DATA export(see scripts/)
    - edit .env : version = 3.20.0
    - docker compose down
    - docker compose up -d

    Upgrade From: >= 3.19.0


### 3.20.alpha2

    YAML editor, Reverse Objects

    - bugix: missing external_id field in user edit form
    - bugfix: p_data_security_edit perm check in merge*
    - bugfix: IPAM: remove surrounding spaces in query field
    - bugfix: handle uuid recompute when is_bound
    - refactor: merge_import/merge_edit/merge_new
    - removed p_import in Schema models (=> p_create/update/delete instead)
    - removed p_export in Schema models (=> p_read instead)
    - removed icon field from classobj/DB : moved to _options
    - demo content-pack out of builtin/
    - UI yaml viewer/editor : schema,instance,user,group,role
    - DATA reverse/related objects in detail view
    - refactor Instance.iterate_classname
    - unittest


    Upgrade Operations:
    - backup DB, CONF,  and DATA export(see scripts/)
    - edit .env : version = 3.20.alpha2
    - docker compose down
    - docker compose up -d
    - optional: add demo  volumes to app in docker-compose : ./demo:/app/demo

    Upgrade From:
    - 3.19.* and +


### 3.20.alpha

    Pivotal release : further upgrade should at least start from 3.20.*
    
    YAML file format evolutions (with backward compatibility)
    new: _options:
    

    Detail
    - update_handle : add safety check if keyname missing
    - UI new/edit : colored section header
    - yaml options keyword renamed to _options  (private)
    - schema _options: keyname_mode: edit*|auto
    - schema _options: handle_show: false*|true
    - schema _options: keyname_label
    - schema _options: displayname_label
    - renamed cli command eav_* to cache_*
    - yaml handle_method moved to _options:  ; rewrite objects to DB (migration)
    - yaml schema permissions under _options in external YAML files
    - yaml schema icon under _options in external YAML files
    - doc/ website included ; hugo + hextra theme


    Upgrade Operations:
    - backup DB, CONF,  and DATA export(see scripts/)
    - .env version = 3.19.0
    - docker compose down
    - docker compose up -d


    Upgrade From:
    - 3.19.*


### Release Notes 3.19.2

    New:
    - bugfix: sirene_message content update (tinymce/htmx collision)
    - UI detail view : toolbar action button left, paginate, bordered table
    - cavaliba_init auto patch sirene_message.handle_method = keyname
    - new conf: CAVALIBA_HOUSEKEEPING_SCHEDULE="22:45"

    Upgrade operations:
    - .env version = 3.19.2


### Release Notes 3.19.1

    - bugfix: boolean in edit form ; wrong display is explicitly False
    - bugfix: is_restricted = False => Data Edit Boolean mismatch 
    - bugfix: sirene demo data => missing bgcolor
    - bugfix: demo data invalid sirene_group (> notify_group)
    - bugfix: /files/ to files/ in sms,mail,templates fs access
    - bugfix: sirene message hask must be keyname, not uuid
    - bugfix: sirene message expand_group maxcount missing in recursion
    - bugfix: sirene, missing widget for Other/x1F7E4 in form editor dropdown
    - refactor Instance() constructors ; split new/load , @classmethod
    - added classname field to DB instance Model (future : deprecate classobj field)
      upgrade: cavaliba eav --eav_refresh --force
    - new standard logger() ; ALPHA
    - eav_purge + daily task
    - schema options framework (ALPHA) ; keyname_mode introduction (disabled)

    Upgrade path:
    - .env version = 3.19.1
    - force new classname field in DataInstance with:
      $ cavaliba eav --eav_refresh --force
    - correct sirene_message handle_method to 'keyname' in DB editor
    

### Release Notes 3.19.0 (ALPHA) - Filestore feature

    - BUGFIX: UI/instance.create() incorrect flash message 
    - FEATURE: app_status : API worklist, workresult for external poller
    - FEATURE: Filestore ALPHA : (x) Model, (x) Field type ; (x) new/edit/detail
    - backup/ directory relative to files/ ; update backup scripts
    - nginx.conf:  for API / file upload:  client_max_body_size 20M;

    Upgrade Path from 3.18.2
    - mkdir files/backup
    - mkdir files/filestore dir
    - (optional) edit nginx.conf and set 'client_max_body_size 20M;' see full download .tar.gz in doubt
    - increment .env version to 3.19.0
    - docker compose down , docker-compose up -d



### Version history

    Version 1.0     - 2024/03/12 - reinit from POC 2023
    Version 1.1     - 2024/03/17 - usergroup exports
    Version 1.2     - 2024/03/24 - config UI, SMS quota, bugfix
    Version 1.3     - 2024/04/01
    Version 1.4     - 2024/04/01 - bugfix
    Version 1.5     - 2024/04/07 - JIT vistor mode, translations, export YAML
    Version 1.6     - 2024/04/14 - UI, sysadmin, stat_view, 
    Version 2.0     - 2024/04/21 - refactor multi-app / url prefix per app
    Version 3.0a    - 2024/06/   - (alpha) switch to framework 
    Version 3.0     - 2024/07/21 - push to PROD/QUAL
    Version 3.1     - 2024/07/29 - UI refresh, split Field, perms on instances
    Version 3.2     - 2024/08/11 - import/export yaml data
    Version 3.3     - 2024/08/15 - export YAML for sirene, UI/paginate data
    Version 3.4     - 2024/08/18 - new data format (date, float, ipv4), data UI paginate
    Version 3.5     - 2024/09/15 - Data bigset / ajax / filter ; tested with 500K entries
    Version 3.6     - 2024/09/22 - groups/roles details + link ; UI ; bugfix
    Version 3.6.1   - 2024/09/22 - quick fix AAA/cache
    Version 3.7     - 2024/09/29 - fieldtypes static/user, UI, ApiKey, UI for AAA details
    Version 3.8     - 2024/10/06 - user: edit w/ group, bigset/ajax, load_csv, log viewer
    Version 3.9     - 2024/10/13 - data_pipeline, data_views(beta), FieldText, load csv refactor
    Version 3.10    - 2024/11/03 - Docker HUB cavaliba/cavaliba:3.10
    Version 3.11    - 2024/11/17 - Refactor DataView, /files/ , /status/, cavaliba naming
    Version 3.11.1  - 2024/11/26 - bugfix cavaliba_load command
    Version 3.11.2  - 2024/11/26 - bugfix cavaliba_load command (pipeline)
    Version 3.12.0  - 2024/12/04 - beta PostgreSQL, var Refactor
    Version 3.13.0a - 2024/12/10 - Docker Hub - API Alpha
    Version 3.13.1  - 2024/12/27 - Feature Handle, Loader : no public release
    Version 3.14.0  - 2025/01/14 - sidebar, instance permission ; >> Docker Hub
    Version 3.14.1  - 2025/01/15 - UI dataview/size in session ; .env Options ; >> Docker Hub
    Version 3.14.2  - 2025/01/22 - dynamic sidebar + UI >> Docker Hub
    Version 3.14.3  - 2025/02/03 - External fieldtype ; permissions #2
    Version 3.14.4  - 2025/02/05 - Bugfix Caching ;  
    Version 3.14.5  - 2025/02/05 - Translation - Font-size
    Version 3.15.0  - 2025/02/15 - Reset Migrations, inject Enumerate subfields ; Docker Hub / GitHub
    Version 3.15.1  - 2025/02/16 - UI detail, refactor cache, global cli, impersonate V2
    Version 3.15.2  - 2025/02/19 - pipeline task primitives
    Version 3.15.3  - 2025/03/02 - externals & subfields
    Version 3.15.4  - 2025/03/16 - unittest, fixtures, UI search/filter, export YAML/JSON
    Version 3.15.5  - 2025/03/23 - exporter/dataview/csv ; quit GitHub
    Version 3.15.6  - 2025/03/24 - bugfix is_multi()
    Version 3.15.7  - 2025/03/30 - cron, multi, default, unittest, granular perms, 
    Version 3.15.8  - 2025/04/02 - bug fix bootstrap app ; debug opt ; impersonate ;  no default perm
    Version 3.15.9  - 2025/04/06 - pipeline, view default permission, demo data
    Version 3.15.10 - 2025/04/09 - pipeline conditions
    Version 3.15.11 - 2025/04/13 - remove oa2p.cfg, backup script, refactor, demo data
    Version 3.15.12 - 2025/04/19 - data_backup, print, 
    Version 3.16    - 2025/05/02 - Sirene Refactor to DataSchema
    Version 3.17.1  - 2025/05/15 - app_status V1
    Version 3.18    - 2025/05/22 - app_ipam v1
    Version 3.18.1  - 2025/05/25 - DataEAV/Reverse ; builtin/demo
    Version 3.18.2  - 2025/05/25 - EAV / IPAM bugfix
    Version 3.19.0  - 2025/06/09 - Filestore, Status API for external poller, bugfix


