# (c) cavaliba.com  - data/api - helper.py

import json
import yaml
import pprint

from django.http import HttpResponse

from app_home.log import log, DEBUG, INFO, WARNING, ERROR, CRITICAL



class MyYamlDumper(yaml.SafeDumper):
    def write_line_break(self, data=None):
        super().write_line_break(data)
        if len(self.indents) < 2:
            super().write_line_break()


def helper():
    print("helped")


def send_not_found():
    return HttpResponse(status=404)


def send_not_implemented():
    return HttpResponse(status=501)


def send_denied():
    return HttpResponse(status=401)    # unauthorized    


def get_page(request):
    try:
        return int(request.GET.get('page', 1))
    except Exception:
        return 1


def get_size(request):
    try:
        return int(request.GET.get('size', 10))
    except Exception:
        return 10

def get_expand(request):
    try:
        return bool(request.GET.get('expand', False))
    except Exception:
        return False


def send_response(request, reply, status):

    #log(DEBUG, app="api", view="ping", action="GET", status="OK", data="")

    # Get output format from URL parameter 'o' (default: json)
    output_format = request.GET.get('o', 'json').lower()

    if output_format == 'yaml':
        content = yaml.dump(reply, allow_unicode=True, sort_keys=False, Dumper=MyYamlDumper, default_flow_style=False)
        content_type = 'application/x-yaml; charset=utf-8'
        return HttpResponse(content, status=status, content_type=content_type)
    
    elif output_format == 'txt':
        content = pprint.pformat(reply, indent=2, width=80)
        content_type = 'text/plain; charset=utf-8'
        return HttpResponse(content+ "\n", status=status, content_type=content_type)
    
    else:
        # Default to JSON : no list if only one item
        if isinstance(reply, list) and len(reply) == 1:
            content = json.dumps(reply[0], indent=2, ensure_ascii=False).encode('utf8')    
        else:
            content = json.dumps(reply, indent=2, ensure_ascii=False).encode('utf8')
        content_type = 'application/json; charset=utf-8'
        return HttpResponse(content+ b"\n", status=status, content_type=content_type)