/*
Copyright © 2025 cavaliba.com
*/
package cmd

import (
	"fmt"
	"os"

	"github.com/spf13/cobra"
	"github.com/spf13/viper"
)

// schemaCmd represents the schema command
var schemaCmd = &cobra.Command{
	Use:     "schema",
	Short:   "display schema information from Cavaliba instance",
	Long:    `Call cavaliba and display schema information`,
	Aliases: []string{"schemas"},

	Run: func(cmd *cobra.Command, args []string) {

		endpoint := "schemas/"

		// Check if --schema flag was provided
		if cmd.Flags().Changed("schema") {
			endpoint = fmt.Sprintf("schemas/%s/", schema)
		}

		target := APITarget{
			url:            viper.GetString("url") + endpoint,
			ssl_skipverify: viper.GetBool("ssl_skipverify"),
		}

		err := AppendGlobalOptions(&target)
		if err != nil {
			fmt.Println(err)
			os.Exit(1)
		}

		PrintVerboseTarget(target)

		result, err := CallAPI(target)
		if err != nil {
			fmt.Println(err)
			os.Exit(0)
		}

		PrintVerboseResult(result)
		fmt.Println(result.body)

	},
}

func init() {
	rootCmd.AddCommand(schemaCmd)
}
