/*
Copyright © 2025 cavaliba.com
*/
package cmd

import (
	"fmt"
	"os"

	"github.com/spf13/cobra"
	"github.com/spf13/viper"
)

// assetCmd represents the asset command
var assetCmd = &cobra.Command{
	Use:     "asset",
	Short:   "displays asset information",
	Long:    `Call cavaliba assets/ API endpoint and displays asset information. Use --id flag to specify an asset ID or --key flag to specify a key.`,
	Aliases: []string{"assets", "instance", "instances"},
	Run: func(cmd *cobra.Command, args []string) {

		endpoint := "assets/"

		// Check if --id flag was provided (priority over schema/key)
		if cmd.Flags().Changed("id") {
			endpoint = fmt.Sprintf("assets/%d/", id)
		} else if cmd.Flags().Changed("schema") && cmd.Flags().Changed("key") {
			// Both schema and key provided: assets/schema/key/
			endpoint = fmt.Sprintf("assets/%s/%s/", schema, key)
		} else if cmd.Flags().Changed("schema") {
			// Only schema provided: assets/schema/
			endpoint = fmt.Sprintf("assets/%s/", schema)
		}

		target := APITarget{
			url:            viper.GetString("url") + endpoint,
			ssl_skipverify: viper.GetBool("ssl_skipverify"),
		}

		err := AppendGlobalOptions(&target)
		if err != nil {
			fmt.Println(err)
			os.Exit(1)
		}

		PrintVerboseTarget(target)

		result, err := CallAPI(target)
		if err != nil {
			fmt.Println(err)
			os.Exit(0)
		}

		PrintVerboseResult(result)
		fmt.Println(result.body)

	},
}

func init() {
	rootCmd.AddCommand(assetCmd)
}
