/*
Copyright © 2025 cavaliba.com
*/
package cmd

import (
	"fmt"
	"os"

	"github.com/spf13/cobra"
	"github.com/spf13/viper"
)

// pingCmd represents the ping command
var pingCmd = &cobra.Command{
	Use:   "ping",
	Short: "ping remote cavaliba instance",
	Long:  `Call cavaliba ping endpoint to check connectivity`,
	Run: func(cmd *cobra.Command, args []string) {

		target := APITarget{
			url:            viper.GetString("url") + "ping/",
			ssl_skipverify: viper.GetBool("ssl_skipverify"),
		}

		result, err := CallAPI(target)
		if err != nil {
			fmt.Println(err)
			os.Exit(0)
		}

		PrintVerbose(target, result)
		fmt.Println(result.body)

	},
}

func init() {
	rootCmd.AddCommand(pingCmd)
}
