# (c) cavaliba.com - data - field - date

import datetime

from .field import Field

# -------------
# DATE
# -------------
class FieldDate(Field):

    # 'YYYY-MM-DD'

    def merge_import(self, data):
        # no split composite !
        self.value = []
        if type(data) is str:
            if len(data) == 10:
                self.value = [data]
        elif type(data) is list:
            for i in data:
                if len(i) == 10:
                    self.value.append(i)

                
    def is_valid(self):
        r = super().is_valid()
        for v in self.value:
            if type(v) is str:
                if len(v) != 10:
                    return False         
            try:
                timeformat = "%Y-%m-%d"
                validtime = datetime.datetime.strptime(v, timeformat)
            except:
                return False
        return r



