# (c) cavaliba.com - tests / helper

import yaml

from app_data.loader import load_broker
from app_data.data import Instance 

from app_user.models import SireneUser
from app_user.models import SireneGroup
from app_user.role import role_get_by_name


def add_admin_user(login="adminuser"):
    user = SireneUser.objects.create(login=login, firstname=login)
    user.save()
    role = role_get_by_name("role_admin")
    role.users.add(user)
    role.save()

def add_user(login="testuser01"):
    user = SireneUser.objects.create(login=login, firstname=login)
    user.save()

def add_group(name="testgroup01"):
    r = SireneGroup(keyname=name, is_role=False)
    r.save()
    return r

def add_role(name="testrole01"):
    r = SireneGroup(keyname=name, is_role=True)
    r.save()
    return r



def add_test_sites(count=5):
    """Create test site entries (site01, site02, etc.)"""
    yaml_entries = []
    for i in range(1, count + 1):
        yaml_entries.append(f'''- classname: site
  keyname: site{i:02d}
  displayname: Site {i:02d}''')
    yaml_str = '\n'.join(yaml_entries)
    datalist = yaml.safe_load(yaml_str)
    aaa = {'perms': ['p_data_create', 'p_data_site_admin']}
    load_broker(datalist=datalist, aaa=aaa, verbose=False)

def add_test_apps(count=5):
    """Create test app entries (app01, app02, etc.)"""
    yaml_entries = []
    for i in range(1, count + 1):
        yaml_entries.append(f'''- classname: app
  keyname: app{i:02d}
  displayname: App {i:02d}''')
    yaml_str = '\n'.join(yaml_entries)
    datalist = yaml.safe_load(yaml_str)
    aaa = {'perms': ['p_data_create', 'p_data_app_admin']}
    load_broker(datalist=datalist, aaa=aaa, verbose=False)

# ---------------------------------------------------------------------------
# schema
# ---------------------------------------------------------------------------

def add_schema(classname='unittest', 
               action='create', 
               displayname=None, 
               options=None, 
               field_definition=None, 
               verbose=False):
    
    """Create a schema object

    Args:
        keyname: Schema key name (unique identifier)
        displayname: Optional display name (defaults to keyname)
        options: Optional dict of _options to set on the schema
        field_definition: Optional dict of field definitions {'fieldname': {'dataformat': 'string', ...}}
        verbose: Enable verbose output during loading

    Returns:
        The created Schema object
    """
    if displayname is None:
        displayname = classname

    yaml_entry = {
        'classname': '_schema',
        '_action': action,
        'keyname': classname,
        'displayname': displayname
    }

    if options:
        yaml_entry['_options'] = options

    if field_definition:
        yaml_entry.update(field_definition)

    datalist = [yaml_entry]
    aaa = {'perms': [
        'p_schema_write',
        ]}
    load_broker(datalist=datalist, aaa=aaa, verbose=verbose)

    from app_data.schema import Schema
    return Schema.from_name(classname)



def add_instance(classname=None, 
                 keyname=None, 
                 action='create',
                 fields=None, 
                 verbose=False):
    """Create a data instance

    Args:
        classname: Schema class name
        keyname: Optional instance key name
        fields: Optional dict of field names to values
        verbose: Enable verbose output during loading
    """
    yaml_entry = {
        'classname': classname,
        '_action': action,
        'keyname': keyname
        }

    if fields:
        yaml_entry.update(fields)

    datalist = [yaml_entry]
    
    aaa = {'perms': [
        'p_data_admin',
        ]}
    
    load_broker(datalist=datalist, aaa=aaa, verbose=verbose)



def add_schema_field(classname='test', fields={}, verbose=False):
    """Add a field to an existing schema

    Args:
        schema_keyname: Schema key name to update
        field_definition: Dict with fieldname keys and field property dicts as values
        verbose: Enable verbose output during loading

    Example:
        add_schema_field('testschema', {
                'field1': { 'dataformat': 'string' },
                'field2': { 'dataformat': 'string', 'displayname': 'myfield2', 'description': 'desc' }
        })
    """
    yaml_entry = {
        'classname': '_schema',
        'keyname': classname
    }

    # Add the field definitions directly to the schema entry
    # field_definition should be a dict like: {'field1': {...}, 'field2': {...}}
    yaml_entry.update(fields)

    datalist = [yaml_entry]

    aaa = {'perms': [
        'p_schema_write',
        ]}
    load_broker(datalist=datalist, aaa=aaa, verbose=verbose)





# ---------------------------------------------------------------------------
# pipeline
# ---------------------------------------------------------------------------


def add_pipeline_noop():

    datalist = yaml.safe_load('''
        - classname: _pipeline
          keyname: pipeline_noop
          displayname: pipeline_noop
          description: pipeline_noop
          is_enabled: True
          content: |
                csv_delimiter: '|'
                classname: test1
                keyfield: keyname
                tasks:
                - field_noop
        ''')
    aaa = {'perms':['p_pipeline_create']}
    load_broker(datalist=datalist, aaa=aaa, verbose=False)



# ---------------------------------------------------------------------------
# api_key
# ---------------------------------------------------------------------------

def add_apikey_admin():
        
        instance = Instance(classname="_apikey", keyname="test")
        data = {
            "secret": "mysecret",
            "ip_filter": "*",
            "is_readonly": True,
            "is_enabled": True,
            "acl": "role:role_admin",
        }
        instance.merge_import(data)
        instance.create()