# (c) cavaliba.com - core urls.py

from django.urls import include, path
from django.shortcuts import render, redirect

import debug_toolbar

import app_sirene.views
import app_home.views

from django.contrib import admin

admin.site.site_header = 'CAVALIBA DB ADMIN'
admin.site.site_title = 'Cavaliba'
admin.site.site_name = "Cavaliba Admin Tools"

# core URLS

urlpatterns = [

    # /status/   => app_home status
    path('status/', app_home.views.status, name='status'),

    # /  >> /sirene/
    path('', app_sirene.views.index),

    # home/  >> app_home
    path('home/', include('app_home.urls')),

    # sirene/
    path('sirene/', include('app_sirene.urls')),
#    path('', include('app_sirene.urls')),

    # user/
    path('user/', include('app_user.urls')),

    # data/
    path('data/', include('app_data.urls')),

    # appstatus/
    path('appstatus/', include('app_status.urls')),

    # ipam/
    path('ipam/', include('app_ipam.urls')),


    # api
    path("api/", include("app_data.urls_api")),


    # local django auth 
    path("accounts/", include("django.contrib.auth.urls")),

    # django admin
    path('private/admin/', admin.site.urls),
    path('private/tinymce/', include('tinymce.urls')),
    
    # DDT
    path("private/__debug__/", include("debug_toolbar.urls")),

]

