---
title: System Configuration 
description: Docker ENV entries for docker compose
weight: 10
---

The `.env` docker file holds several important system parameters. It is used at startup when issuing the `docker compose up -d` startup command. You must restart the application when modifications to *env* occur.

---

## Docker Image Configuration

### CAVALIBA_DOCKER_IMAGE

```
CAVALIBA_DOCKER_IMAGE=cavaliba/cavaliba:3.21.0
```

Name of the docker registry, docker image and version for the Cavaliba Application. The default value displayed above queries Docker Hub, for the public cavaliba repository, cavaliba image object, with a version 3.21.0. You can use any public/private image repository that can be accessed from your docker host. You can build your own cavaliba image from source code with the provided dockerfile.

---

## Internationalization

### CAVALIBA_LANGUAGE_CODE

```
CAVALIBA_LANGUAGE_CODE="en-us"
```

Sets the default language for the user interface. Examples: `en-us` (English), `fr-FR` (French), `de-DE` (German). Users can override this in their profile settings.

### CAVALIBA_TIME_ZONE

```
CAVALIBA_TIME_ZONE="Europe/Paris"
```

Specifies the server timezone for all timestamps and scheduled tasks. Examples: `UTC`, `Europe/Paris`, `America/New_York`, `Asia/Tokyo`. This affects when daily housekeeping tasks run.

---

## Authentication and Admin Account

### CAVALIBA_AUTH_MODE

```
CAVALIBA_AUTH_MODE=local
```

Determines the authentication mechanism used for user login. Options: `local` (Cavaliba internal user database), `basic` (HTTP Basic Auth), `oauth2` (external identity provider), `forced` (automatic login). Default to `local` for initial deployment. `oauth2` is recommended for enterprise or large user-base deployment.

### CAVALIBA_FORCE_LOGIN

```
CAVALIBA_FORCE_LOGIN=admin
```

Username to automatically log in when using `forced` authentication mode. When set, all requests are authenticated as this user without requiring credentials. Only used when `CAVALIBA_AUTH_MODE=forced`. Useful for individual use, demo / tests.

### CAVALIBA_ADMIN_PASSWORD

```
CAVALIBA_ADMIN_PASSWORD=change_again
```

Initial password for the default admin user account used to access the Cavaliba web interface. The login is `admin`. Set this value immediately before first start. To change the password later, use the database admin tool or Django manage tool with `createsuperuser` command.

### CAVALIBA_ADMIN_EMAIL

```
CAVALIBA_ADMIN_EMAIL=admin@mydomain.com
```

Email address associated with the default admin user account. Used for password recovery and administrative notifications. Can be modified through the UI after login.

### CAVALIBA_SESSION_DURATION

```
CAVALIBA_SESSION_DURATION=3600
```

Maximum session timeout in seconds for inactive users (default: 3600 = 1 hour). After this period of inactivity, users are automatically logged out for security. Example: Set to `7200` for 2 hours.

---

## Network and Security

### CAVALIBA_PORT

```
CAVALIBA_PORT=8000
```

Network port the Cavaliba nginx container will expose and listen to on the host. This is the port users use to access the application. Must not conflict with other services. Example: Set to `80` for HTTP, `8080` for alternative port.

### CAVALIBA_CSRF_TRUSTED_ORIGINS

```
CAVALIBA_CSRF_TRUSTED_ORIGINS="http://127.0.0.1:8000 https://mycavaliba.mydomain.com"
```

Space-separated list of allowed origins (schema, FQDN and port) for CSRF protection. CSRF protection will be valid only for the listed entries. **You must set this entry according to your environment**. Example: `https://cavaliba.company.com` for production.

### CAVALIBA_ALLOWED_HOSTS

```
CAVALIBA_ALLOWED_HOSTS="localhost 127.0.0.1 *"
```

A space-separated list of strings representing the host/domain names that this Django site can serve. This is a security measure to prevent HTTP Host header attacks, which are possible even under many seemingly-safe web server configurations. Example: `cavaliba.example.com cavaliba-backup.example.com` for specific hosts.

### CAVALIBA_SECRET_KEY

```
CAVALIBA_SECRET_KEY=changeme_with_a_long_string
```

A random long string used to protect session cookies in Cavaliba. Must be changed from the default for security. If you change the value and restart Cavaliba, all users will be signed-out of the application. Example: Use a 50+ character random string.

### CAVALIBA_CIPHER_KEY

```
CAVALIBA_CIPHER_KEY="a_very_secret_string"
```

The secret key to encrypt sensitive information in the Cavaliba Database (e.g., user passwords, API tokens, SMS content). If you lose or change this value, previous encrypted content from the database will be lost. Use a strong, random string and keep it secure.

---

## Tenant and Multi-Instance

### CAVALIBA_TENANT

```
CAVALIBA_TENANT=cavaliba
```

The name/prefix of the docker objects (container name, docker network) created when starting Cavaliba. Use one value per docker-compose.yml file to start several simultaneous Cavaliba instances on the same host. Don't forget to also select a different network listening port for each. Each instance is isolated on a different docker bridge. Example: `cavaliba-prod`, `cavaliba-test`, `cavaliba-dev`.

---

## Database Configuration

### CAVALIBA_DB_ENGINE

```
CAVALIBA_DB_ENGINE=django.db.backends.mysql
```

The database backend type. Options: `django.db.backends.mysql` (MariaDB/MySQL - default, production-tested), `django.db.backends.postgresql` (PostgreSQL - beta support). For now, only MariaDB/MySQL is recommended for production.

### CAVALIBA_DB_HOST

```
CAVALIBA_DB_HOST=cavaliba_db
```

Hostname or IP address of the database server. The `cavaliba_db` is the docker DNS name of the internal database service. If you decide to use an external DB server (physical/VM or cloud service), replace with the exact hostname/FQDN. Example: `db.example.com` or `10.0.0.50`.

### CAVALIBA_DB_PORT

```
CAVALIBA_DB_PORT=3306
```

Port number for database connection. Default: `3306` for MySQL/MariaDB, `5432` for PostgreSQL. Must match the database service configuration. Ensure the port is open and accessible from the Cavaliba container.

### CAVALIBA_DB_DATABASE

```
CAVALIBA_DB_DATABASE=cavaliba
```

Name of the database created for Cavaliba. The application expects this database to exist with appropriate schema. Can be customized per deployment. Example: `cavaliba_prod`, `my_app_db`.

### CAVALIBA_DB_USER

```
CAVALIBA_DB_USER=cavaliba
```

Database user account for Cavaliba application connections. This user needs SELECT, INSERT, UPDATE, DELETE, CREATE privileges on the Cavaliba database. Example: `cavaliba_app`, `app_user`.

### CAVALIBA_DB_PASSWORD

```
CAVALIBA_DB_PASSWORD=changeme_please
```

Password for the database user account running Cavaliba application queries. Must be strong and kept secure. Different from `CAVALIBA_DB_ROOT_PASSWORD`. Example: Use a 20+ character random string.

### CAVALIBA_DB_ROOT_PASSWORD

```
CAVALIBA_DB_ROOT_PASSWORD=changeme_please_also
```

Root/admin password for database administration and backup operations. Used by Docker Compose to initialize the database. Must be changed for security before production use. If the MariaDB is dedicated to Cavaliba, identical values for PASSWORD and ROOT_PASSWORD are acceptable.

---

## File Storage

### CAVALIBA_FILESTORE

```
CAVALIBA_FILESTORE="/app/files/filestore/"
```

Directory path where uploaded files are stored. Must be writable by the application container. Can be mounted from a shared volume for persistent file storage across container restarts. Example: `/mnt/nfs/cavaliba/files/` for NFS-mounted storage.

---

## Scheduled Tasks

### CAVALIBA_HOUSEKEEPING_SCHEDULE

```
CAVALIBA_HOUSEKEEPING_SCHEDULE="21:34"
```

Time of day (HH:MM format) when the daily maintenance task runs. Handles log purging, message archival, cache refresh, and other cleanup operations. Example: `02:00` for 2 AM execution, `03:30` for 3:30 AM.

---

## Email/SMTP Configuration

### CAVALIBA_EMAIL_HOST

```
CAVALIBA_EMAIL_HOST=localhost
```

SMTP server hostname or IP for sending outbound email notifications. Usually the mail server of your organization. Example: `mail.company.com`, `smtp.gmail.com`, `10.0.0.100`.

### CAVALIBA_EMAIL_PORT

```
CAVALIBA_EMAIL_PORT=25
```

SMTP server port number. Typically `25` for unencrypted, `465` for SSL, `587` for TLS. Must match the mail server configuration. Ensure the port is open from the container. Example: Change to `587` for TLS-based SMTP.

### CAVALIBA_EMAIL_USER

```
#CAVALIBA_EMAIL_USER=noreply
```

Username for SMTP authentication if required by your mail server. Leave commented (empty) if your mail server doesn't require authentication. Often a shared service account. Example: `notifications@company.com`.

### CAVALIBA_EMAIL_PASSWORD

```
#CAVALIBA_EMAIL_PASSWORD=changeme
```

Password for SMTP authentication if required by your mail server. Leave commented (empty) for open relays. Required for external mail providers like Gmail or SendGrid. Example: App-specific password for Gmail SMTP.

---

## SMS Configuration

### CAVALIBA_SMS_URL

```
CAVALIBA_SMS_URL="https://my.sms.provider.com/api/"
```

Base URL of the SMS gateway API provider. The application constructs SMS sending requests to this endpoint. Must support the required API format. Example: `https://api.clicsecure.com/send/` for ClicSecure.

### CAVALIBA_SMS_LOGIN

```
CAVALIBA_SMS_LOGIN="my_sms_account"
```

Account login/ID for the SMS gateway service. Required to authenticate API requests to the SMS provider. Different from Cavaliba user accounts. Example: Your account email or username from SMS provider.

### CAVALIBA_SMS_PASSWORD

```
CAVALIBA_SMS_PASSWORD="changeme"
```

Authentication password or API key for the SMS gateway service. Must be obtained from your SMS provider. Kept secure in the environment configuration. Example: API token or account password from SMS provider.

---

## Cache and Message Queue

### CAVALIBA_CACHE_DEFAULT_URL

```
CAVALIBA_CACHE_DEFAULT_URL="redis://cavaliba_redis:6379"
```

Redis connection URL for general application caching (permissions, schema cache). The `cavaliba_redis` is the docker DNS name. Can point to external Redis instances or cloud services. Example: `redis://redis.company.com:6379` or `redis://user:pass@redis.cloud.com:6380/0`.

### CAVALIBA_CACHE_SESSION_URL

```
CAVALIBA_CACHE_SESSION_URL="redis://cavaliba_redis:6379"
```

Redis connection URL specifically for user session storage. Can point to a different Redis instance for session management. Affects login state persistence. Example: Same as CACHE_DEFAULT_URL or separate Redis for dedicated session cache.

### CAVALIBA_CELERY_BROKER_URL

```
CAVALIBA_CELERY_BROKER_URL="redis://cavaliba_redis:6379"
```

Redis connection URL for Celery task queue (background jobs). This is where background job tasks are queued. Must be accessible to both app and worker containers. Example: `redis://celery-broker.company.com:6379`.

### CAVALIBA_CELERY_RESULT_BACKEND

```
CAVALIBA_CELERY_RESULT_BACKEND="redis://cavaliba_redis:6379"
```

Redis connection URL for Celery task results storage. Stores results of completed background tasks. Can use the same Redis instance as the broker. Example: `redis://results.company.com:6379` for separate result storage.

---

## OAuth2 Proxy and Federation

### Identity Provider Configuration

#### OAUTH2_PROXY_PROVIDER

```
OAUTH2_PROXY_PROVIDER="oidc"
```

OAuth2/SAML identity provider type. Options: `oidc` (OpenID Connect), `keycloak-oidc` (Keycloak), `google`, `azure`, etc. Determines which protocol and configuration format is used for federated authentication.

#### OAUTH2_PROXY_PROVIDER_DISPLAY_NAME

```
OAUTH2_PROXY_PROVIDER_DISPLAY_NAME="MyKeycloak"
```

User-friendly name for the identity provider displayed on the login page. Helps users identify which authentication method to use. Example: `MyOkta`, `Corporate Active Directory`, `Azure AD`.

#### OAUTH2_PROXY_OIDC_ISSUER_URL

```
OAUTH2_PROXY_OIDC_ISSUER_URL="https://keycloak.example.com/realms/myrealm"
```

Complete URL of the OIDC identity provider for discovery. Used for OAuth2 discovery endpoints. Must match your IdP configuration exactly including protocol and port. Example: `https://okta.company.com`, `https://keycloak.example.com:8080/realms/cavaliba`.

#### OAUTH2_PROXY_CLIENT_ID

```
OAUTH2_PROXY_CLIENT_ID="cavaliba-client"
```

OAuth2 application ID provided by your identity provider. Identifies the Cavaliba application within the IdP. Obtained during application registration. Example: Long alphanumeric string from your IdP.

#### OAUTH2_PROXY_CLIENT_SECRET

```
OAUTH2_PROXY_CLIENT_SECRET="your_client_secret"
```

OAuth2 application secret/password provided by your identity provider. Used to authenticate the application with the IdP. Must be kept secure and not shared. Example: Generated secret string from IdP.

#### OAUTH2_PROXY_COOKIE_SECRET

```
OAUTH2_PROXY_COOKIE_SECRET="your_cookie_secret"
```

Secret key for signing OAuth2 proxy session cookies. Must be a long random string (24+ characters). Used to prevent cookie tampering and session hijacking. Example: Base64-encoded 24-character random string.

#### OAUTH2_PROXY_REDIRECT_URL

```
OAUTH2_PROXY_REDIRECT_URL="https://cavaliba.example.com/oauth2/callback"
```

Callback URL where the identity provider redirects after successful authentication. Must exactly match the URL configured in your identity provider application settings. Must use HTTPS in production. Example: `https://my.cavaliba.fqdn/oauth2/callback`.

### Common OAuth2 Settings

#### OAUTH2_PROXY_COOKIE_EXPIRE

```
OAUTH2_PROXY_COOKIE_EXPIRE="0h45m0s"
```

OAuth2 session cookie expiration time (format: `HhMmSs`). After this period, users must re-authenticate. Shorter durations increase security but reduce convenience. Example: `0h30m0s` for 30 minutes, `2h0m0s` for 2 hours.

#### OAUTH2_PROXY_HTTP_ADDRESS

```
OAUTH2_PROXY_HTTP_ADDRESS="0.0.0.0:4180"
```

Network address and port where OAuth2 proxy listens. The nginx reverse proxy forwards requests here. `0.0.0.0` makes it accessible from all interfaces. Port 4180 is the default. Example: `127.0.0.1:4180` to restrict local connections only.

#### OAUTH2_PROXY_SKIP_PROVIDER_BUTTON

```
OAUTH2_PROXY_SKIP_PROVIDER_BUTTON="true"
```

Whether to skip showing provider selection button (true/false). When `true`, automatically redirects to the single configured provider. Useful for single IdP deployments.

#### OAUTH2_PROXY_EMAIL_DOMAINS

```
OAUTH2_PROXY_EMAIL_DOMAINS="*"
```

Allowed email domains for OAuth2 login. `*` allows all domains. Restrict to specific domains for security. Example: `company.com` or `company.com external.com` for multiple domains.

### Header Propagation

#### OAUTH2_PROXY_SET_XAUTHREQUEST

```
OAUTH2_PROXY_SET_XAUTHREQUEST="true"
```

Pass user identity to backend as X-Auth-Request header (true/false). When `true`, Cavaliba receives the authenticated username and can verify the identity.

#### OAUTH2_PROXY_SET_AUTHORIZATION_HEADER

```
OAUTH2_PROXY_SET_AUTHORIZATION_HEADER="true"
```

Pass OAuth2 token as Authorization header to backend (true/false). Allows Cavaliba to access token information for additional validation or claims.

#### OAUTH2_PROXY_PASS_AUTHORIZATION_HEADER

```
OAUTH2_PROXY_PASS_AUTHORIZATION_HEADER="true"
```

Preserve Authorization header from OAuth2 proxy to Cavaliba (true/false). When `true`, Cavaliba can directly use the authorization header for additional authentication.

#### OAUTH2_PROXY_PASS_ACCESS_TOKEN

```
OAUTH2_PROXY_PASS_ACCESS_TOKEN="true"
```

Pass the OAuth2 access token to the backend application (true/false). Allows Cavaliba to use the token for calling other APIs on behalf of the user.

### Session and Security

#### OAUTH2_PROXY_SESSION_STORE_TYPE

```
OAUTH2_PROXY_SESSION_STORE_TYPE="redis"
```

Storage backend for OAuth2 sessions. `redis` uses Redis for distributed deployments. Must be set to `redis` for multi-instance deployments.

#### OAUTH2_PROXY_REDIS_CONNECTION_URL

```
OAUTH2_PROXY_REDIS_CONNECTION_URL="redis://cavaliba_redis"
```

Redis connection URL for OAuth2 session storage. Sessions are stored here for scalability across multiple OAuth2 proxy instances. Example: `redis://redis.company.com:6379`.

#### OAUTH2_PROXY_COOKIE_HTTPONLY

```
OAUTH2_PROXY_COOKIE_HTTPONLY="false"
```

Prevent JavaScript access to OAuth2 session cookies (true/false). When `true`, improves security against XSS attacks. Recommended value: `true`.

#### OAUTH2_PROXY_COOKIE_SECURE

```
OAUTH2_PROXY_COOKIE_SECURE="true"
```

Require HTTPS for OAuth2 session cookies (true/false). When `true`, cookies are not sent over unencrypted HTTP. Should be `true` in production. Set to `false` only for development.

#### OAUTH2_PROXY_COOKIE_REFRESH

```
OAUTH2_PROXY_COOKIE_REFRESH="true"
```

Refresh OAuth2 session cookie on each request (true/false). When `true`, extends session timeout with activity. Improves user experience but increases overhead.

#### OAUTH2_PROXY_COOKIE_SAMESITE

```
OAUTH2_PROXY_COOKIE_SAMESITE="lax"
```

SameSite policy for OAuth2 cookies. Options: `lax` (recommended), `strict` (most secure), `none` (least secure). `lax` is a good balance between security and usability.

#### OAUTH2_PROXY_COOKIE_CSRF_EXPIRE

```
OAUTH2_PROXY_COOKIE_CSRF_EXPIRE="7m"
```

CSRF protection cookie expiration (format: `XmYs`). These temporary cookies protect against cross-site request forgery attacks during login. Example: `5m` for 5 minutes, `10m` for 10 minutes.

### Logging Configuration

#### OAUTH2_PROXY_AUTH_LOGGING

```
OAUTH2_PROXY_AUTH_LOGGING="true"
```

Enable logging of authentication attempts and decisions (true/false). Useful for debugging login issues and monitoring authentication events.

#### OAUTH2_PROXY_STANDARD_LOGGING

```
OAUTH2_PROXY_STANDARD_LOGGING="true"
```

Enable standard operational logging of OAuth2 proxy (true/false). Logs proxy startup, configuration, and general operational events.

#### OAUTH2_PROXY_REQUEST_LOGGING

```
OAUTH2_PROXY_REQUEST_LOGGING="false"
```

Log all HTTP requests to OAuth2 proxy (true/false). Creates verbose logs of every request. Useful for debugging but impacts performance and log size.

#### OAUTH2_PROXY_SHOW_DEBUG_ON_ERROR

```
OAUTH2_PROXY_SHOW_DEBUG_ON_ERROR="false"
```

Display debug information when errors occur (true/false). Shows detailed error messages and stack traces. Disable in production for security.

---

## Application Server Configuration

### GUNICORN_CMD_ARGS

```
GUNICORN_CMD_ARGS="--workers=5 --log-level info --max-requests 500 --access-logfile '-' --error-logfile '-' --graceful-timeout 2"
```

Gunicorn WSGI application server configuration. Controls number of worker processes, request limits, timeouts, and logging. Key options:
- `--workers=N`: Number of worker processes (typically CPU_count + 1). Example: `--workers=8` for 8 cores.
- `--max-requests N`: Recycle worker after N requests (prevents memory leaks). Example: `--max-requests 1000`.
- `--log-level`: Logging level (`debug`, `info`, `warning`, `error`, `critical`). Example: `--log-level warning` for less verbose.
- `--timeout N`: Request timeout in seconds. Example: `--timeout 60` for 60 seconds.

Example for high-traffic: `--workers=16 --max-requests 5000 --log-level warning --timeout 120`

---

## Debug and Development

### CAVALIBA_DEBUG

```
CAVALIBA_DEBUG=0
```

Enable Django debug mode (0 for off, 1 for on). **Set to 0 in PRODUCTION**. When enabled, shows detailed error pages and disables security features. Never enable in production. Example: Set to `1` only in development/testing environments.

### CAVALIBA_DEBUG_IP

```
CAVALIBA_DEBUG_IP="127.0.0.1 172.19.0.1"
```

Space-separated list of IP addresses to enable Django Debug Toolbar and additional debug features. Only these IPs see debug information. Used by developers to troubleshoot issues. Example: `192.168.1.100 10.0.0.50` for specific developer IPs.

### CAVALIBA_DEBUG_AAA

```
CAVALIBA_DEBUG_AAA="no"
```

Enable detailed logging of permission system (AAA) operations (yes/no). Shows AAA module decisions and checks for authentication/authorization debugging. Set to `yes` only when troubleshooting permission issues.
