---
title: string
description: FieldType String
weight: 210
---

Represents a text string value. The most common and flexible field type for storing text data.

## dataformat: string

```yaml
  MYFIELD:
      dataformat: string
      dataformat_ext: [safe|url]
      default: "default text"
```

## dataformat_ext

Optional **dataformat_ext** can be one of:

- **safe**: Display unescaped HTML content in detail view (use with caution for security)
- **url**: Display as a clickable hyperlink (`<a>` tag) in detail view
- *(none)*: Plain text display (default)

## Multivalue

Multi-value is supported. Useful for storing multiple text values in a single field.

```yaml
## SCHEMA
MYTAGS:
      dataformat: string
      cardinal_max: 0

## INSTANCE multi-valued
  MYTAGS: [tag1, tag2, tag3]
  # or as space-separated string
  MYTAGS: 'tag1 tag2 tag3'
```

## Examples

### Schema Definition

```yaml
- classname: _schema
  keyname: person
  name:
    dataformat: string
    displayname: Full Name
    description: Person's complete name
```

### Instance Example

```yaml
- classname: person
  keyname: john_smith
  name: "John Smith"
```
