# (c) cavaliba.com - home - api.py

import json

from pprint import pprint

from django.http import HttpResponse
from django.views.decorators.csrf import csrf_exempt, csrf_protect

from django.utils.translation import gettext as _

from app_home.log import log, DEBUG, INFO, WARNING, ERROR, CRITICAL
from app_home.configuration import get_configuration


from app_home.cavaliba import CAVALIBA_VERSION

from app_user.api import start_api


#  ----------------------------------------------------------------------------
# /home/api/
#  ----------------------------------------------------------------------------
@csrf_exempt
def index(request):
    return HttpResponse(status=401)    # unauthorized

#  ----------------------------------------------------------------------------
# /home/api/version/
#  ----------------------------------------------------------------------------
@csrf_exempt
def version(request):

    # reply = {}
    # reply["is_allowed"] = False
    # reply["keyname"] = None
    # reply["is_readonly"] = True
    # reply["error"] = "no action performed"
    # reply["user_ip"] = None
    # reply["acl_filter"] = None
    # reply["permissions"] = []

    reply = start_api(request)

    if not reply:
        return HttpResponse(status=401)    # unauthorized

    if "is_allowed" not in reply:
        return HttpResponse(status=401)    # unauthorized

    if not reply["is_allowed"]:
        return HttpResponse(status=401)    # unauthorized

    if request.method != "GET":
        return HttpResponse(status=401)    # unauthorized

    if "p_info" not in reply["permissions"]:
        return HttpResponse(status=401)    # unauthorized
    
    reply = {"version":CAVALIBA_VERSION}
    #pprint(reply)
    
    myjson = json.dumps(reply, indent=4, ensure_ascii = False).encode('utf8')
    
    return HttpResponse(myjson + b"\n")

