# (c) cavaliba.com - tests / helper

import yaml

from app_data.loader import load_broker

from app_user.models import SireneUser
from app_user.models import SireneGroup
from app_user.role import role_get_by_name


def add_admin_user(login="adminuser"):
    user = SireneUser.objects.create(login=login, firstname=login)
    user.save()
    role = role_get_by_name("role_admin")
    role.users.add(user)
    role.save()

def add_user(login="testuser01"):
    user = SireneUser.objects.create(login=login, firstname=login)
    user.save()

def add_group(name="testgroup01"):
    r = SireneGroup(keyname=name, is_role=False)
    r.save()
    return r

def add_role(name="testrole01"):
    r = SireneGroup(keyname=name, is_role=True)
    r.save()
    return r



def add_test_sites(count=5):
    """Create test site entries (site01, site02, etc.)"""
    yaml_entries = []
    for i in range(1, count + 1):
        yaml_entries.append(f'''- classname: site
  keyname: site{i:02d}
  displayname: Site {i:02d}''')
    yaml_str = '\n'.join(yaml_entries)
    datalist = yaml.safe_load(yaml_str)
    aaa = {'perms': ['p_data_create', 'p_data_site_admin']}
    load_broker(datalist=datalist, aaa=aaa, verbose=False)

def add_test_apps(count=5):
    """Create test app entries (app01, app02, etc.)"""
    yaml_entries = []
    for i in range(1, count + 1):
        yaml_entries.append(f'''- classname: app
  keyname: app{i:02d}
  displayname: App {i:02d}''')
    yaml_str = '\n'.join(yaml_entries)
    datalist = yaml.safe_load(yaml_str)
    aaa = {'perms': ['p_data_create', 'p_data_app_admin']}
    load_broker(datalist=datalist, aaa=aaa, verbose=False)




def add_pipeline_noop():

    datalist = yaml.safe_load('''
        - classname: _pipeline
          keyname: pipeline_noop
          displayname: pipeline_noop
          description: pipeline_noop
          is_enabled: True
          content: |
                csv_delimiter: '|'
                classname: test1
                keyfield: keyname
                tasks: 
                - field_noop                                                   
        ''')
    aaa = {'perms':['p_pipeline_create']}
    load_broker(datalist=datalist, aaa=aaa, verbose=False)

