---
title: User and Groups
description: Create, import, export, and manage users in Cavaliba - UI, YAML, CSV, and pipelines
weight: 20
draft: false
---

User management is a core component of Cavaliba's IAM (Identity & Access Management) system. In this section, we'll explore multiple ways to create and manage users: through the web interface, bulk imports via YAML files.

We'll then move on to Groups which are the proper way to organize users by any characteristic, and to provide a more manageable object to scale Cavaliba to tens of thousands users or more.


## Create a User from the UI

Let's start by creating a user directly from the Web UI.

### User List

Click on Users in the sidebar. When you first navigate to the Users section, it's mostly empty, except for the built-in admin account or any previously created user.


![Users Empty List](users_empty.png)

### Edit the user form

Click the `New` button to open the user creation form and fill it in:

![New User Form](new_user.png)

The form includes fields for:
- **Login** - Unique username for authentication ; mandatory field.
- **First Name** - User's first name
- **Last Name** - User's last name
- **Display Name** - Full name or display identifier
- **Email** - Primary email address
- **Mobile** - Phone number
- **Description** - Additional notes or purpose
- **Enabled** - Toggle to activate/deactivate the user
- **Notification Preferences** - Email/SMS notification settings

Fill in the required fields and click "Save".

### User details

After saving, you'll see a confirmation message and the user appears in the Detail window :

![New User Created](new_user_done.png)

The user list now shows your newly created user with details like login, display name, and email.

![User List with Created User](new_user_list.png)


## Bulk Import Users

For any practical deployment, you will import multiple users at once (and periodically), using CSV, JSON or YAML files, or API REST calls. Cavaliba provides demo user data that you can load directly.

We've already seen in PART-1 how to Import from the UI Import tool.

This time we'll use the CLI command to import a set of demo users already included in the Cavaliba application :

```bash
cavaliba load builtin/demo/010_user.yaml
```

![Bulk Import Users Command](user_bulk.png)

This command loads users defined in the demo YAML file. 






## Note on the User YAML format

Users imported from YAML follow this schema:

```yaml
- classname: _user
  login: adela81
  firstname: Marijn
  lastname: ...
  (...)
```
The `login` field is the primary key. An email format is accepted. Mandatory fields are `classname: _user` and `login`(`keyname` is supported to match general Schema). Similar JSON structure are supported.

The underscore before the user schema, indicates a builtin Schema. Don't use underscore for your own Assets schema names.

We can inspect (and edit) the YAML code of any object from the UI.

In the search filter, enter a username and click on the search button. Choose a user from the filtered list of users and click on its name. You should see the detailed page for this user.

Open the Action dropdown menu and select `Code`.

![Code Edit](user_edit_code.png)

You're now in the `Import` tool we've seen on PART-1, filled with the users' YAML description. You can modify and import to replace the previous values. 

![User YAML](user_yaml.png)


## Working with CSV file format

The CSV file format is also available for import in Cavaliba. But its use is covered in a later PART of this tutorial as it requires `Pipelines` object to pre-process the data from CSV file.


## Export Users

Cavaliba allows you to export users to similar format for backup, sharing, or integration with other systems.

Use the export functionality in the User UI (dropdown Export) or CLI to download your user data in various formats.

![Export Users from UI](user_export_from_ui.png)

From the command line (CLI):

```bash
# Export to JSON
cavaliba schema --export _user

# Export to YAML
cavaliba schema --export _user --format yaml
```

## Delete a user 

You can delete users from the Web UI. Find the user and use the `Delete` button from the `Action` dropdown.

![User Delete](user_delete.png)


Conversely, you can delete an user with some JSON or YAML code (CLI or UI Import tool):

```yaml
- classname: _user
  login: adela81
  _action: delete
```

Other action values are available:
- init ; only creates the object if it doesn't exist 
- update ; only  update the object ; do nothing if it doesn't exist ; only provided values will be updated, other fields are left untouched

Try to retrieve a Delete operation in the Logs


## Disabling User

Every object - User, Group, and all objects from user-defined Schema -  can be deactivated. This makes them unavailable in the UI or Data models, without the risk associated with permanent deletion.

From a Web UI Form edit a User or any object. Unset the is_enabled box

![User Disable](user_disable.png)

From JSON/YAML, use the `is_enabled` attribute:

```yaml
- classname: _user
  login: adela81
  is_enabled: no
```

Cavaliba supports the following values for `is_enabled` : yes,no, Yes, True, false, 0, 1, on, OFF, etc.


## Managing Large User Datasets

Once you have imported users via any method (UI, YAML, JSON), you can:
- Edit individual user records
- Bulk update, manually or automatically
- Export for backup or integration
- Organize users into groups (see the Groups part of this tutorial)
- Assign roles and permissions (see the IAM & Permissions)

You'll see later how to configure periodical import/export task, or use the REST API to remotely import/export Users and other data objects.


## Groups

If you have more than a few users in your organization, it'll quickly become tedious to manage them one by one in Cavaliba. By managing, we mean assigning them permission, refering to them in Assets Schema, configuring them for permissions, etc.

Groups let you well ... group users with similar characteristics. 

You can create an *Accountant* group, and affect all accountant Users to that group. 

### From the UI


Let's create a group from the UI.

### from JSON/YAML code


### Nested groups

Groups are well suited to describe hierarchical organization.

A group can contain subgroups. And so on.



### bulk import groups for the tutorial

```bash
cavaliba load builtin/demo/014_group_mgmt.yaml
``` 

Take some time to inspect groups in the UI. Look at YAML code (Action menu > Code) ; check operations in Logs or Data Revision as seen in PART-1

