# (c) cavaliba.com - tests / sirene / views

from django.test import override_settings
from django.test import TestCase
from django.test import TransactionTestCase
from django.urls import reverse
from django.core.cache import cache as cache_django

from tests import helper

from app_user.models import SireneUser
from app_user.role import role_get_by_name

import app_home.cache as cache
from app_home.models import CavalibaConfiguration



class SireneViews(TestCase):

    fixtures = ["test"]

    def setUp(self):

        helper.add_admin_user(login="unittest")
        cache.clear()
        cache_django.clear()

        # user = SireneUser.objects.create(
        #     login="unittest", firstname="unittestname")
        # user.save()

        # role = role_get_by_name("role_default")
        # role.users.add(user)
        # role.save()

    # def tearDown(self):
    #     super().tearDown()
    #     cache_django.clear()


    # Anonymous
    # ---------

    # not logged-in
    @override_settings(CAVALIBA_AUTH_MODE="local")
    def test_public(self):
        response = self.client.get(reverse('app_sirene:index'))
        self.assertEqual(response.status_code, 200)


    @override_settings(CAVALIBA_AUTH_MODE="local")
    def test_anonymous_ko(self):
        response = self.client.get(reverse('app_sirene:anonymous'))
        # print(response.content)
        self.assertEqual(response.status_code, 302)


    def test_trusted_ip(self):
        conf = CavalibaConfiguration.objects.get(
            appname="user", keyname="TRUSTED_ANONYMOUS_IPS")
        conf.value = "0.0.0.0/0"
        conf.save()

        response = self.client.get(reverse('app_sirene:anonymous'))
        self.assertEqual(response.status_code, 200)

        response = self.client.get(reverse('app_sirene:private'))
        self.assertEqual(response.status_code, 302)


    # user
    # ----

    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_user_public(self):
        response = self.client.get(reverse('app_sirene:index'))
        self.assertEqual(response.status_code, 200)

    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_user_anonymous(self):
        response = self.client.get(reverse('app_sirene:anonymous'))
        self.assertEqual(response.status_code, 200)

    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_user_private(self):
        response = self.client.get(reverse('app_sirene:private'))
        self.assertEqual(response.status_code, 200)

    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_user_archive(self):
        response = self.client.get(reverse('app_sirene:archive'))
        self.assertEqual(response.status_code, 200)

    # -- flush all GET/POST

    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_user_flushall_get(self):
        response = self.client.post(reverse('app_sirene:flushall'), follow=True)
        a = ('/sirene/private/', 302)
        #print(response.redirect_chain)
        self.assertTrue(a in response.redirect_chain)


    # operator
    # --------

    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_operator_public(self):
        response = self.client.get(reverse('app_sirene:index'))
        self.assertEqual(response.status_code, 200)

    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_operator_anonymous(self):
        response = self.client.get(reverse('app_sirene:anonymous'))
        self.assertEqual(response.status_code, 200)

    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_operator_private(self):
        response = self.client.get(reverse('app_sirene:private'))
        self.assertEqual(response.status_code, 200)

    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_operator_archive(self):
        response = self.client.get(reverse('app_sirene:archive'))
        self.assertEqual(response.status_code, 200)

    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_operator_smsjournal(self):
        #helper.add_admin_user()
        response = self.client.get(reverse('app_sirene:sms_journal'))
        self.assertEqual(response.status_code, 200)

    # -- flush all GET/POST

    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_operator_flushall_get(self):
        response = self.client.get(reverse('app_sirene:flushall'), follow=True)
        # self.assertEqual(response.status_code, 302)
        a = ('/sirene/', 302)
        # print(response.redirect_chain)
        self.assertTrue(a in response.redirect_chain)

    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_operator_flushall_post(self):
        response = self.client.post(
            reverse('app_sirene:flushall'), follow=True)
        a = ('/sirene/private/', 302)
        # print(response.redirect_chain)
        self.assertTrue(a in response.redirect_chain)


    # admin
    # -----


    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_public(self):
        response = self.client.get(reverse('app_sirene:index'))
        self.assertEqual(response.status_code, 200)

    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_anonymous(self):
        response = self.client.get(reverse('app_sirene:anonymous'))
        # user = admin
        self.assertEqual(response.status_code, 200)

    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_trusted_ip(self):
        conf = CavalibaConfiguration.objects.get(
            appname="user", keyname="TRUSTED_ANONYMOUS_IPS")
        conf.value = "0.0.0.0/0"
        conf.save()

        response = self.client.get(reverse('app_sirene:anonymous'))
        self.assertEqual(response.status_code, 200)

    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_private_access(self):
        response = self.client.get(reverse('app_sirene:private'))
        self.assertEqual(response.status_code, 200)
