---
title: Authorizations
description: Data Reference
weight: 205
draft: true
---

## Data Authorization model

User access to Data Ressources requires a combination of **two** authorizations:

1. Global - Operations Authorization on All Data Ressources  (access/read/write/...) ; given by Permissions.

2. Class/Schema - Operations Authorizations on specific Class/Schema ; given by Roles attached to Class/Schema


## Global permissions

Global operations on all Data objects is controlled by a small set Permissions.

```
     ("p_data_access", "Access UI", "", False),
     ("p_data_class_ro", "Access RO on classes", "", False),
     ("p_data_class_rw", "Access RWD on classes", "", False),
     ("p_data_schema_ro", "Schema RO", "", False),
     ("p_data_schema_rw", "Schema RWD", "", False),
     ("p_data_instance_ro", "Global RO on instances", "", False),
     ("p_data_instance_rw", "Global RWD on instances", "", False),
     ("p_data_import", "Use file or YAML import tool", "", False),
     ("p_data_admin", "Other sensitive actions on data app", "", False),
```

you may provide thes Permissions to users through standard Role/Group. You can use Built-in Roles.


## Built-in Roles

Give the following Roles to Users and Groups to provide Global Authorization.


```yaml

ROLES_BUILTIN = {
    'role_data_ro': [
        "p_data_access",
        "p_data_class_ro",
        "p_data_schema_ro",
        "p_data_instance_ro",

    ],
    # class: create/update/delete/onoff
    'role_data_rw': [
        "p_data_access", 
        "p_data_class_rw",
        "p_data_schema_rw",
        "p_data_instance_rw",
    ],
    # class: import/export
    'role_data_admin': [
        "p_data_access", 
        "p_data_class_rw",
        "p_data_schema_rw",
        "p_data_instance_rw",
        "p_data_import",
        "p_data_admin",
    ],
}



```


## Per Class/Schema Authorizations

Per Class/Schema Authorization is provided by Roles and is mandatory in addition to Global Authorization.

Each class has a set of `_role` attributes to define which Role controls allowed operation on the Class and its Instances.


```yaml
# role definitions ...

_role:role_data_test_ro:
    displayname: Role DATA test RO
    subgroups:
      - usergroup1


_role:role_data_test_rw:
    displayname: Role DATA test RW
    subgroups:
      - usergroup2

_role:role_data_test_admin:
    displayname: Role DATA test ADMIN
    subgroups:
      - usergroup3

# .. can be used in specific Class/Schema definition:

_schema:test_class:
    
    _role_show: role_data_test_ro
    _role_access: role_data_test_ro
    _role_read: role_data_test_ro
    _role_create: role_data_test_rw
    _role_update: role_data_test_rw
    _role_delete: role_data_test_rw
    _role_onoff: role_data_test_rw
    _role_import: role_data_test_admin
    _role_export: role_data_test_admin

```


## Per Instance Authorization

Not implemented.


## Per Field Authorization

Not implemented.