---
title: Welcome to Cavaliba
layout: hextra-home
---

{{< hextra/hero-badge >}}
  <div class="hx:w-2 hx:h-2 hx:rounded-full hx:bg-primary-400"></div>
  <span>Free, open source, BSD 3-clause license</span>
  {{< icon name="arrow-circle-right" attributes="height=14" >}}
{{< /hextra/hero-badge >}}

<div class="hx:mt-6"><br></div>

<div class="hx:mt-6 hx:mb-6">
{{< hextra/hero-headline >}}
  One platform, your data, many tools.&nbsp;<br class="hx:sm:block hx:hidden" />
{{< /hextra/hero-headline >}}
</div>

<div class="hx:mt-6"><br></div>

<div class="hx:mb-6">
{{< hextra/hero-button text="Get Started" link="docs" >}}
</div>

<div class="hx:mt-6"><br></div>



<div class="hx:mt-6"></div>

{{< hextra/feature-grid >}}

  {{< hextra/feature-card
    title="Philosophy: integration is key"
    subtitle="A shared and well designed data model can provide much value. Small applications (minimal feature-set) using that data model, can also bring much value. By comparison,  standalone applications with large feature-sets, but with poor integration fail to deliver to their promise."
  >}}

  {{< hextra/feature-card
    title="Dynamic Data Models"
    subtitle="Define custom models for any asset type (Locations, Users, Applications, Devices, etc.). Start with predefined models, edit them at runtime, or build from scratch. Add, modify, or remove fields in realtime with simple or advanced field types, and enforce constraints for data quality."
  >}}


  {{< hextra/feature-card
    title="Manage granular permissions"
    subtitle="User, groups, roles, permissions let you manage operations on asset families, individual objects, even at field level."
  >}}


  {{< hextra/feature-card
    title="Web UI by default"
    subtitle="For each model, you get a full UI Web Interface to manage your assets : List, Search, Edit, Import, Export assets. Responsive, automatically generated, no code."
  >}}

  {{< hextra/feature-card
    title="Dataviews for data subsets"
    subtitle="Create dataviews for frequent access to subsets of your data. Tailor presented data to your users. Select a predefined dataview in the UI for instant access."
  >}}


  {{< hextra/feature-card
    title="REST API"
    subtitle="Query, Add or Edit assets with a standard HTTP REST API, basically JSON over HTTP. Granular Permissions included."
  >}}

  {{< hextra/feature-card
    title="CLI command"
    subtitle="Use a provided Command line (CLI) tool to manage Assets families or individual items."
  >}}


  {{< hextra/feature-card
    title="Import Data"
    subtitle="Bulk import data from external sources such as CSV, YAML, JSON. Apply Pipeline operators during import  and before storage. A powerful set of operators enable many data transformations."
  >}}


  {{< hextra/feature-card
    title="Export Data"
    subtitle="Bulk export, full assets families or subsets, to CSV, YAML, JSON format"
  >}}


  {{< hextra/feature-card
    title="SAML/OIDC - Federated authentication"
    subtitle="Connect to your Identity Provider with SAML / OIDC. Use LDAP, external web authentication or even local user accounts if needed."
  >}}


  {{< hextra/feature-card
    title="Fast with large datasets"
    subtitle="Cavaliba is fast. With large datasets and complex data models, UI response time is immediate even on small virtual machines or modest container platform. Tested with more than 500 000 objects per Asset Schema, or 50K+ user entries."
  >}}

  {{< hextra/feature-card
    title="Open Source permissive licence and Free"
    subtitle="3-clause open source BSD license. Do what you want."
  >}}

  {{< hextra/feature-card
    title="Deploy with Docker"
    subtitle="Cavaliba is provided as a set of docker containers with no external dependency after startup. Run the provided docker-compose in minutes."
  >}}

  
  {{< hextra/feature-card
    title="Hosting and Sovereignty"
    subtitle="Host where you want : on a VM virtual machine on-premise, in the cloud, on a desert island. No web dependency, no callback, no tracker, no ad. Everything is in the box."
  >}}

{{< hextra/feature-card
    title="Pricing"
    subtitle="Cavaliba software is free and open-source with a BSD 3-clause license, and all features included. No SAAS Software as a Service offering is available at the moment. See **Support** if you need external services"
  >}}


{{< hextra/feature-card
    title="Need Support ?"
    subtitle="Drop an email to contact@. We can get you in touch with professional services for Cavaliba support, either RUN oriented (deploy/run) or DATA/USAGE oriented (data model, training)."
  >}}
  
  {{< hextra/feature-card
    title="APP - Sirene Notification"
    subtitle="Included. Notify your users in case of Outage / Maintenance ; Public/Private web page, templates, emails, SMS. Updates, Archive..."
  >}}

  {{< hextra/feature-card
    title="APP - CMDB"
    subtitle="Included. At hearth, Cavaliba is a full powered CMDB - Configuration Managment Data Base system."
  >}}


  {{< hextra/feature-card
    title="APP - IPAM IP Address Management"
    subtitle="Included. Upload, redefine, search, manage your network addresses, VLAN and more."
  >}}

  {{< hextra/feature-card
    title="APP - Service Status Uptime"
    subtitle="Included.  IT service monitoring (uptime status). Define your URLs and expected answers. Enjoy automatic uptime informations, hourly, daily, monthly, ... Green/Yellow/Red reports, uptime ratio per day, month, year, ..."
  >}}

    {{< hextra/feature-card
    title="More apps to come ..."
    subtitle="Stay tuned."
  >}}
{{< /hextra/feature-grid >}}



<div class="hx:mt-6"><br></div>

