# (c) cavaliba.com - unittest app_status

from django.test import TestCase, override_settings
from django.test import TransactionTestCase
from django.urls import reverse
from django.core.cache import cache as cache_django

from app_home.configuration import get_configuration
import app_home.cache as cache

from app_user.models import SireneUser, SireneGroup
from app_user.role import role_get_by_name



class AppStatusTest(TestCase):

    fixtures = ["test"]

    def setUp(self):
        cache.init()
        cache_django.clear()

        user = SireneUser.objects.create(login="unittest", firstname="unittestname")
        user.save()

        role = role_get_by_name("role_admin")
        role.users.add(user)
        role.save()

    def tearDown(self):
        cache_django.clear()


    #@override_settings(CAVALIBA_DEBUG_AAA="yes")
    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_override_settings(self):
        r = get_configuration("env", "CAVALIBA_AUTH_MODE")
        self.assertEqual(r, 'unittest')


    #@override_settings(CAVALIBA_DEBUG_AAA="yes")
    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_appstatus_list(self):
        response = self.client.get(reverse('app_status:list'))
        self.assertEqual(response.status_code, 200)        
