# (c) cavaliba.com - tests data export

from django.test import TestCase, override_settings
from django.test import TransactionTestCase
from django.urls import reverse


import app_home.cache as cache
from app_home.models import CavalibaConfiguration
from app_user.models import SireneUser
from app_user.models import SireneGroup
from app_user.role import role_get_by_name


class DataExportTest(TestCase):

    fixtures = ["test"]

    def setUp(self):
        user = SireneUser.objects.create(login="unittest", firstname="unittestname")
        user.save()
        role = role_get_by_name("role_admin")
        role.users.add(user)
        role.save()
        cache.init()

    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_data_export_csv(self):
        response = self.client.post(reverse('app_data:data_export'),{ 
            'classname': 'test1',
            'page':'allpages',
            'dv':'___ALL___',
            'query':'',
            'format':'csv',
            })
        
        self.assertEqual(response.status_code, 200)
        self.assertContains(response, "test1-01")
        #print(response.content)


    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_data_export_yaml(self):
        response = self.client.post(reverse('app_data:data_export'),{ 
            'classname': 'test1',
            'page':'allpages',
            'dv':'___ALL___',
            'query':'',
            'format':'yaml',
            })
        
        self.assertEqual(response.status_code, 200)
        self.assertContains(response, "test1-01")
        #print(response.content)


    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_data_export_json(self):
        response = self.client.post(reverse('app_data:data_export'),{ 
            'classname': 'test1',
            'page':'allpages',
            'dv':'___ALL___',
            'query':'',
            'format':'json',
            })
        
        self.assertEqual(response.status_code, 200)
        self.assertContains(response, "test1-01")
        #print(response.content)



# with dataview

    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_data_export_yaml_dataview1(self):
        response = self.client.post(reverse('app_data:data_export'),{ 
            'classname': 'test1',
            'page':'allpages',
            'dv':'test1_enumerate_inject',
            'query':'',
            'format':'yaml',
            })
        
        self.assertEqual(response.status_code, 200)
        self.assertContains(response, "test1-01")
        self.assertContains(response, "Widget")
        #print(response.content)



    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_data_export_yaml_dataview2(self):
        response = self.client.post(reverse('app_data:data_export'),{ 
            'classname': 'test1',
            'page':'allpages',
            'dv':'test1_welcome',
            'query':'',
            'format':'yaml',
            })
        
        #print(response.content)
        self.assertEqual(response.status_code, 200)
        self.assertContains(response, "test1-01")
        self.assertContains(response, "invalid")
        



    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_data_export_json_dataview(self):
        response = self.client.post(reverse('app_data:data_export'),{ 
            'classname': 'test1',
            'page':'allpages',
            'dv':'test1_welcome',
            'query':'',
            'format':'json',
            })
        
        self.assertEqual(response.status_code, 200)
        self.assertContains(response, "test1-01")
        #print(response.content)