# (c) cavaliba.com - home - urls.py

from django.urls import path

from app_home import views
from app_home import api

# url namespace
app_name="app_home"

urlpatterns = [

    # home/ >>  home/private/
    path('',  views.private, name='index'),
    path('private/', views.private, name='private'),

    # conf
    path('private/conf/', views.configuration, name='configuration'),
    path('private/conf/<slug:appname>/', views.configuration, name='configuration'),

    # logs
    path('private/log/', views.logview, name='log'),
    path('private/log/l/<str:level>/', views.logview, name='log'),
    path('private/log/purge/', views.logview, name='logpurge'),

    # api ; in descending order
    path('api/', api.index, name='api_home_index'),
    path('api/version/', api.version, name='api_version'),
    # path('api/classes/', api.classes, name='api_classes'),
    # path('api/c/<slug:classname>/', api.classname, name='api_classname'),
    # path('api/c/<slug:classname>/i/<slug:keyname>/', api.instance, name='api_instance'),
    # path('api/import/', api.api_import, name='api_import'),
    # path('api/csv/<slug:classname>/', api.api_csv, name='api_csv'),




]