# (c) cavaliba.com - data - field - user

from .field import Field

from app_home.configuration import get_configuration

from app_user.models import SireneUser

from app_user.user import user_get_by_login
from app_user.user import user_get_login_by_email

# -------------
# USER
# -------------
class FieldUser(Field):


    def get_attribute(self):
        ''' return list of SireneUser '''
        # self.value = ["a", "b", ..."]

        reply = []

        for login in self.value:
            userobj = user_get_by_login(login)
            reply.append(userobj)
        return reply


    def get_datapoint_ui_detail(self):

        datapoint = super().get_datapoint_ui_detail()

        datapoint["value"] = []
        users = SireneUser.objects.filter(login__in=self.value, is_enabled=True)
        for i in users:
            item = { "key":i.login, "display":i.displayname, "id":i.id  }
            datapoint["value"].append(item)

        return datapoint        



    def get_datapoint_ui_edit(self):

        # value: [ { 'key':'keyname' , 'selected':True/False }, ...    ]

        datapoint = super().get_datapoint_ui_edit()

        datapoint["value"] = []
    
        # count = SireneUser.objects.count()
        # bigset_size = int(get_configuration("data","DATA_BIGSET_SIZE"))
        datapoint["bigset"] = True

        users = SireneUser.objects.filter(login__in=self.value, is_enabled=True)
        for i in users:
            selected = True
            item = { "key":i.login, "display":i.displayname, "selected":selected}
            datapoint["value"].append(item)

        return datapoint        



    def merge_import(self, data):
        
        super().merge_import(data)
        #self.value = split_composite(data)
    
        # custom behavior    
        processed = []
        for login in self.value:
            # if @, lookup by email
            if '@' in login:
                login2 = user_get_login_by_email(login)
                processed.append(login2)
            else:    
                processed.append(login)
        self.value = processed


    def is_valid(self):
        r = super().is_valid()
        # TODO
        return r