---
title: Docker env configuration
description: Docker ENV entries for docker compose
weight: 801
---

Thoe `.env`docker file holds several important system parameters.
Is it used at startup when issuing the `docker compose up -d` startup command.


**CAVALIBA_DOCKER_IMAGE**

    CAVALIBA_DOCKER_IMAGE=cavaliba/cavaliba:3.21.0

Name of the docker registry, docker image and version for the Cavaliba Application. The default value displayed above queries Docker Hub, for the public cavaliba repository, cavaliba image object, with a version 3.21.0. You can use any public/private image repository that can be accessed from your docker host. You can build your own cavaliba image from source code wih the provided dockerfile.



**Cavaliba Authentication and built-in Admin account**

    # local, basic, oauth2, forced
    CAVALIBA_AUTH_MODE=local
    # if forced mode
    CAVALIBA_FORCE_LOGIN=admin
    # admin built-in account
    CAVALIBA_ADMIN_PASSWORD=change_again
    CAVALIBA_ADMIN_EMAIL=admin@mydomain.com

    # UI session duration max (default 3600 seconds)
    CAVALIBA_SESSION_DURATION=36000

Internal Built-in account used to access Cavaliba Web Application and DB web admin tool. It is created during the first launch of Cavaliba,  and re-creation is attempted at every new launch.

The login is `admin`.

To change the password, use the DB web admin tool. You can also use the django manage tool with the createsuperuser command.

**CAVALIBA_PORT**

    CAVALIBA_PORT=8000

Network port the cavaliba nginx container will expose and listen to on the Host.


**CAVALIBA_CSRF_TRUSTED_ORIGINS**

    CAVALIBA_CSRF_TRUSTED_ORIGINS="http://127.0.0.1:8000 https://mycavaliba.mydomain.com"
    
String and blank separated list of schema, FQDN and port for  hosts hosting the Cavaliba Application. CSRF protection will be valid only for the listed entries.

You **must** set this entry according to your environment.


**CAVALIBA_ALLOWED_HOSTS**

    CAVALIBA_ALLOWED_HOSTS="localhost 127.0.0.1 *"

From Django documentation: *A list of strings representing the host/domain names that this Django site can serve. This is a security measure to prevent HTTP Host header attacks, which are possible even under many seemingly-safe web server configurations.*

**CAVALIBA_SECRET_KEY**

    CAVALIBA_SECRET_KEY=changeme_with_a_long_string

Set a random long string to protect session cookies used by Cavaliba. If you change the value and restart Cavaliba, all users will be signed-out of the application.


**CAVALIBA_CIPHER_KEY** 

     CAVALIBA_CIPHER_KEY="a_very_secret_string"

The secret key to encrypt sensitive information in the Cavaliba Database. If you lose or change this value, previous content from the database will be lost.

Use case: SMS content for the SMS_Send feature in Sirene App.


**CAVALIBA_TENANT**

    CAVALIBA_TENANT=cavaliba

The name/prefix of the docker objects (container name, docker network) created whden starting cavaliba. Use one value per docker-compose.yml file to start several simultaneous Cavaliba instance on a same host. Don't forget to also select a different network listening port for each. Each instance is isolated on a different docker bridge.

Change this value if you plan to host several Cavaliba isolated deployment on the same Host/VM.


**DB options**

    CAVALIBA_DB_ENGINE=django.db.backends.mysql
    CAVALIBA_DB_HOST=cavaliba_db
    CAVALIBA_DB_PORT=3306
    CAVALIBA_DB_DATABASE=cavaliba
    CAVALIBA_DB_USER=cavaliba
    CAVALIBA_DB_PASSWORD=changeme_please
    CAVALIBA_DB_ROOT_PASSWORD=changeme_please_also


By default, Cavaliba is provided with an internal MariaDB database instance (container), dedicated to the Cavaliba application. This parameters define the important values to create the DB and connect the Application.

The **CAVALIBA_DB_HOST** is the docker DNS name of the database server. If you decide to use an external DB server (either physical/VM or cloud service) you need to replace with the exact hostname / FQDN. For single or multiple Cavaliba instance in docker mode, you don't need to change this value.

If the MariaDB is dedicated to Cavaliba (as with the the provided configuration), there is no issue to having identical values for PASSWORD and ROOT_PASSWORD.

For the moment, only MariaDB/MySQL is supported. PostGreSQL may be added later.


**Identity Federation options**

    OAUTH2_PROXY_PROVIDER="oidc"
    OAUTH2_PROXY_PROVIDER_DISPLAY_NAME=""
    OAUTH2_PROXY_OIDC_ISSUER_URL=""
    OAUTH2_PROXY_CLIENT_ID=""
    OAUTH2_PROXY_CLIENT_SECRET=""
    OAUTH2_PROXY_COOKIE_SECRET=""
    OAUTH2_PROXY_REDIRECT_URL=""


**Email/SMTP configurations**

    CAVALIBA_EMAIL_HOST=localhost
    CAVALIBA_EMAIL_PORT=25
    # uncomment if authentication needed
    #CAVALIBA_EMAIL_USER=noreply
    #CAVALIBA_EMAIL_PASSWORD=changeme

**SMS configurations**

    CAVALIBA_SMS_URL="https://my.sms.provider.com/api/"
    CAVALIBA_SMS_LOGIN="my_sms_account"
    CAVALIBA_SMS_PASSWORD="changeme"

**Cache**

    CAVALIBA_CACHE_DEFAULT_URL="redis://cavaliba_redis:6379"
    CAVALIBA_CACHE_SESSION_URL="redis://cavaliba_redis:6379"
    CAVALIBA_CELERY_BROKER_URL="redis://cavaliba_redis:6379"
    CAVALIBA_CELERY_RESULT_BACKEND="redis://cavaliba_redis:6379"


**Other**

    # keep 0 in PRODUCTION
    CAVALIBA_DEBUG=0
    CAVALIBA_DEBUG_IP="127.0.0.1 172.19.0.1"


