---
title: Cavaliba App Configuration
description: Configuration
weight: 802
---

From the Cavaliba Web UI with appropriate permissions, you can configure many parameters and options for a cavaliba deployment. 

![config](configuration.png)

This page explains most parameters.

Usage:
* Use the `Configuration` entry in the sidebar. 
* Navigate to the desired configuration section. 
* Don't forget to save after modifying an option.
* Effect is immediate. No reload/no restart needed.

Permission needed: `p_conf_admin`

### HOME/GLOBAL_APPNAME
This string defines the top Link in the Sidebar.

### HOME/CSV_DELIMITER
If not specified in a pipeline, CSV managed by Cavaliba will assume this character as a column separator.

### HOME/LOGO_SIZE
If a (company) logo is provided in the files/logo/logo.png, this parameter will govern the width of the displayed logo in the sidebar. If 0, no logo. But a Global Appname.

### HOME/LOG_KEEP_DAYS_DEBUG
Log entries with DEBUG level are kept in the database (for interactive access in the Web UI) that amount of days. A periodic task (daily) does the cleanup.

### HOME/LOG_KEEP_DAYS_INFO
Log entries with INFO level are kept in the database (for interactive access in the Web UI) that amount of days. A periodic task (daily) does the cleanup.

### HOME/LOG_KEEP_DAYS_WARNING
Log entries with WARNING level are kept in the database (for interactive access in the Web UI) that amount of days. A periodic task (daily) does the cleanup.

### HOME/LOG_KEEP_DAYS_ERROR
Log entries with ERROR level are kept in the database (for interactive access in the Web UI) that amount of days. A periodic task (daily) does the cleanup.

### HOME/LOG_KEEP_DAYS_CRITICAL
Log entries with CRITICAL level are kept in the database (for interactive access in the Web UI) that amount of days. A periodic task (daily) does the cleanup.

### HOME/LOG_MAX_ENTRIES
### HOME/LOG_EXCLUDED_IP
### HOME/LOG_DEBUG
### HOME/SIDEBAR_ENV
### HOME/SIDEBAR_COLOR
### HOME/BETA_PREVIEW

### USER/Cache Sessions
### USER/TRUSTED_ANONYMOUS_IPS
### USER/AUTH_LOGIN_REMOVE_DOMAIN
### USER/AUTH_FEDERATED_LOGIN_FIELD
### USER/AUTH_FEDERATED_EMAIL_FIELD
### USER/AUTH_JUST_IN_TIME


### DATA/DATA_DEFAULT_SIZE
### DATA/DATA_MAX_SIZE
### DATA/DATA_BIGSET_SIZE
### DATA/EXPORT_INTERACTIVE_MAX_SIZE

### SIRENE/SIRENE_APPNAME
Displayed name for the Sirene (Notification) Application.

### SIRENE/PUBLIC_MAX_ITEMS
### SIRENE/DEFAULT_DURATION_MINUTE
### SIRENE/PUBLIC_SORT_ORDER
### SIRENE/PUBLIC_SKIP_TO_TRUSTED
### SIRENE/USER_MAX_NOTIFICATION
### SIRENE/EMAIL_MAX_NOTIFICATION
### SIRENE/EMAIL_MODE
### SIRENE/EMAIL_FOLDER
### SIRENE/EMAIL_FROM
### SIRENE/EMAIL_SMTP_BATCH
### SIRENE/EMAIL_PREFIX
### SIRENE/EMAIL_UPDATE_PREFIX
### SIRENE/EMAIL_TEST_SUBJECT
### SIRENE/EMAIL_TEST_CONTENT
### SIRENE/SMS_MAX_NOTIFICATION
### SIRENE/SMS_QUOTA_PER_DAY
### SIRENE/SMS_MODE
### SIRENE/SMS_FOLDER
### SIRENE/SMS_PREFIX
### SIRENE/SMS_UPDATE_PREFIX
### SIRENE/SMS_TEST
### SIRENE/SMS_WARNING
### SIRENE/NOTIFY_FIELDS
### SIRENE/NOTIFY_SUBSCRIPTIONS

### STATUS/STATUS_APPNAME
Displayed name for the Status Monior Application.

### STATUS/STATUS_RAW_KEEP_DAYS
### STATUS/STATUS_SAMPLE_HOUR_KEEP_DAYS

### IPAM/IPAM_APPNAME
Displayed name for the IPAM Application.






