---
title: IAM - User and Access
description: User, and access
weight: 300
---



**Users**, **Groups**, **Permissions**, and **Roles** are the foundation of the security model in Cavaliba.
They describe who can access Cavaliba, and what action theyr are allowed to perform. 


They are used for Authentication (user identity and proof),  Authorization (what can users do) and Accounting (audit trail, who did what). These three topics are known and refered to as the **AAA** Model.


Users and Groups are also used to describe your Organization or Company from a business point of view. For example within the Notification App, you may wish to notify all HR Users. An "HR Group" will provide this notification target.


## What are Users, Roles, Groups, Permissions ?

* **Users** are objects describing a real person using Cavaliba, or being refered to in the data model
* **Groups** are sets of similar users related to any characteristic you like (organization, business activity, Position, ...)
* **Permissions** are atomic auhtorizations to perform a specific action in Cavaliba and the data within.
* **Roles** are sets of permissions associated with users and groups to be grant those permissions. 

To map users to permissions, you use Roles.

Groups are organizational units to group people without no security criteria. 


## User creation and modification

* From Cavaliba Web User Interface  (UI)
* From YAML / JSON / CSV file import with cavaliba command line (CLI)
* From REST API calls
* From dynamic (Just-In-Time) Provisiong, after a first usccessful (external) authentication


## User authentication

Cavaliba supports several mechanisms :

* Default/Local Application mode with web login/pawsword sign-in forms, and an in-app internal user base
* External HTTP Basic/Digest Authentication - at the NGINX Tier ;  Cavaliba uses HTTP Authentication Headers
* External SAML / OIDC federated identity - at the NGINX Tier ; an authentication workflow is triggered to an external Identity provider :  Keycloak, Okta, Microsoft 365, etc. Response Token are used by Cavaliba to identify the user
* No Authentication / Forced authentication : in this single user mode, a unique user is always logged in to Cavaliba.

A direct AD/LDAP authentication may be implemented later. However it is already available with the Federation mode to a Keycloak Identity Provider which in turns use an AD/LDAP as a user backend. 

## Tips and tricks

You should not map Users to Roles directly. Use groups instead to gather similar users, and then link groups to roles.


## Technical implementations

Internally, Roles are Groups objects, but with a specific attribut "is_role". They can be edited to add permissions, which groups cannot.

