# (c) cavaliba.com - unittest iam view

from django.test import TestCase, override_settings
from django.test import TransactionTestCase
from django.urls import reverse
from django.core.cache import cache as cache_django

from app_home.configuration import get_configuration
import app_home.cache as cache

from app_user.models import SireneUser, SireneGroup
from app_user.role import role_get_by_name



class IAMViews(TestCase):

    fixtures = ["test"]

    def setUp(self):
        cache.init()
        cache_django.clear()

        user = SireneUser.objects.create(login="unittest", firstname="unittestname")
        user.save()

        role = role_get_by_name("role_admin")
        role.users.add(user)
        role.save()

    def tearDown(self):
        cache_django.clear()


    #@override_settings(CAVALIBA_DEBUG_AAA="yes")
    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_override_settings(self):
        r = get_configuration("env", "CAVALIBA_AUTH_MODE")
        self.assertEqual(r, 'unittest')


    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_user_private(self):
        response = self.client.get(reverse('app_user:private'), follow=True)
        self.assertEqual(response.status_code, 200)        

    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_user_debug(self):
        response = self.client.get(reverse('app_user:debug'))
        self.assertEqual(response.status_code, 200)        

    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_user_logout(self):
        response = self.client.get(reverse('app_user:logout'), follow=True)
        self.assertEqual(response.status_code, 200)        




    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_user_list(self):
        response = self.client.get(reverse('app_user:user_list'))
        self.assertEqual(response.status_code, 200)        

    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_user_detail(self):
        #response = self.client.get(reverse('app_user:user_detail', args=["1"]), follow=True )
        response = self.client.get(reverse('app_user:user_detail', kwargs={'userid':1}), follow=True )
        self.assertEqual(response.status_code, 200)        


    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_user_edit_new(self):
        response = self.client.get(reverse('app_user:user_edit'), follow=True )
        self.assertEqual(response.status_code, 200)        
        self.assertContains(response, 'csrfmiddlewaretoken')


    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_user_edit_1(self):
        response = self.client.get(reverse('app_user:user_edit', args=[1]), follow=True )
        self.assertEqual(response.status_code, 200)
        self.assertContains(response, 'csrfmiddlewaretoken')
        #print(response.content)

    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_user_delete_1(self):
        response = self.client.get(reverse('app_user:user_delete', args=[1]), follow=True )
        self.assertEqual(response.status_code, 200)


    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_user_pref(self):
        response = self.client.get(reverse('app_user:user_pref'), follow=True )
        self.assertEqual(response.status_code, 200)

    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_user_email_test(self):
        response = self.client.get(reverse('app_user:email_test', args=[1]), follow=True )
        self.assertEqual(response.status_code, 200)

    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_user_sms_test(self):
        response = self.client.get(reverse('app_user:sms_test', args=[1]), follow=True )
        self.assertEqual(response.status_code, 200)

    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_user_impersonate(self):
        response = self.client.get(reverse('app_user:impersonate'), follow=True )
        self.assertEqual(response.status_code, 200)

    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_user_impersonate_testuser01(self):
        response = self.client.get(reverse('app_user:impersonate', kwargs={'newlogin':'testuser01'}), follow=True )
        self.assertEqual(response.status_code, 200)

    # @override_settings(CAVALIBA_AUTH_MODE="unittest")
    # def test_user_impersonate_testuser_invalid(self):
    #     response = self.client.get(reverse('app_user:impersonate', kwargs={'newlogin':'testuser_invalid'}), follow=True )
    #     self.assertEqual(response.status_code, 200)
    #     #self.assertContains(response, 'Please sign-in')
    #     print(response.content)

# group



    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_group_list(self):
        response = self.client.get(reverse('app_user:group_list'))
        self.assertEqual(response.status_code, 200)        

    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_group_detail(self):
        response = self.client.get(reverse('app_user:group_detail', kwargs={'gid':1}), follow=True )
        self.assertEqual(response.status_code, 200)        


    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_group_edit_new(self):
        response = self.client.get(reverse('app_user:group_edit'), follow=True )
        self.assertEqual(response.status_code, 200)        
        self.assertContains(response, 'csrfmiddlewaretoken')


    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_group_edit_1(self):
        response = self.client.get(reverse('app_user:group_edit', args=[1]), follow=True )
        self.assertEqual(response.status_code, 200)
        self.assertContains(response, 'Not allowed')
        #print(response.content)

    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_group_delete_1(self):
        response = self.client.get(reverse('app_user:group_delete', args=[25]), follow=True )
        self.assertEqual(response.status_code, 200)
