# (c) cavaliba.com - home - tasks.py

from time import sleep

from django.core import management

from celery import shared_task

from app_home.configuration import get_configuration
import app_home.cache as cache

from app_home.log import log, DEBUG, INFO, WARNING, ERROR, CRITICAL
               
from app_home.log import purge


from app_data.data import update_bigset
from app_data.eav import eav_refresh
from app_data.eav import eav_purge




@shared_task
def housekeeping_daily():

    aaa = None
    
    log(INFO, aaa=aaa, app="cron", view="housekeeping", action="start", status="OK", data=f"DAILY HOUSEKEEPING STARTED ...")


    # update_bigset
    log(INFO, aaa=aaa, app="cron", view="housekeeping", action="update_bigset", status="OK", data="")
    update_bigset()

    # eav_refresh
    log(INFO, aaa=aaa, app="cron", view="housekeeping", action="eav_refresh", status="OK", data=f"eav_refresh start ...")
    count_create, count_update, count = eav_refresh(dryrun=False, force=False)
    #eav_refresh(verbose=verbose, dryrun=dryrun, force=force, progress=progress)

    log(INFO, aaa=aaa, app="cron", view="housekeeping", action="eav_refresh", status="OK", 
        data=f"eav_refresh done: {count_create} created, {count_update} updated, {count} total")
    
    # eav_purge
    log(INFO, aaa=aaa, app="cron", view="housekeepin", action="eav_purge", status="OK", data=f"eav_purge start ...")
    count_delete, count = eav_purge()
    log(INFO, aaa=aaa, app="cron", view="housekeeping", action="eav_purge", status="OK", 
        data=f"eav_purge done : {count_delete} deleted, {count} total")

    # log purge
    aaa = None
    count = purge(aaa=aaa)
    log(INFO, aaa=aaa, app="cron", view="housekeeping", action="log_purge", status="OK", data=f"{count} removed")


    # V3.15.11 - clear sessions
    aaa = None
    management.call_command('clearsessions')
    log(INFO, aaa=aaa, app="cron", view="housekeeping", action="clear_session", status="OK", data=f"cleared expired sessions")


    # TODO 
    # filestore cleanup
    # forced eav refresh




    # done
    log(INFO, aaa=aaa, app="cron", view="housekeeping", action="done", status="OK", data=f"DAILY HOUSEKEEPING DONE")



# #@app.task
# @shared_task
# def log_purge():

#     aaa = None
#     count = purge(aaa=aaa)
#     log(INFO, aaa=aaa, app="home", view="cron_housekeeping", action="log_purge", status="OK", data=f"{count} removed")


# # V3.15.11
# @shared_task
# def clear_expired_sessions():
#     management.call_command('clearsessions')
#     aaa = None
#     log(INFO, aaa=aaa, app="home", view="cron", action="clear_session", status="OK", data=f"cleared expired sessions")