---
title: SAML/OIDC Authentication 
description: Configure SAML/OIDC Authentication 
weight: 850
---


SAML/OIDC  Authentication is an **external** authentication mode. It is called OAUTH2 in Cavaliba.

It is performed by a companion component, namely **oauth2_proxy**, which is included in Cavaliba as an additional container, ready to be started and configured.

This model is suitable for modern/large scale deployment. It offloads all the access / authentication process to an external Authentication server (IdP, Identity Provider). It may provide Multi-factor strong authentication, and many user self-service to manage their account and credentials depending on the IDP.

Identity Providers are external services such as Keycloak, OKTA, Microsoft Azure AD and numerous other providers.


## steps to configure

Identity Provider
* Register your Cavaliba deployement to your IDP (identity provider)

Provision users in advance
* if coming from other AUTH MODE such as local, create users matching users in your IDP, with appropriate permissions

System & Docker
* in the .env docker file, configure the IDP parameters (client id, secret, URLs)
* in the .env docker file, configure CAVALIBA_AUTH_MODE=oauth2
* in docker-compose.yaml,  uncomment the oauth2_proxy container bloc
* in nginx.conf, uncomment the oauth2 configuration blocs ; comment basic authentication if any
* restart docker containers


## Setup a local Keycloak IDP

TBD - start a local Keycloak container, configure User directory, authentication workflows. Register Cavaliba as a a new Service Provider for this IDP.


## Bonus : LDAP Authentication

LDAP authentication is a mean to authenticate users against a central  Directory like Openldap, Lemonldap or Active Directory.

Although not immediately available in Cavaliba it can be set up with the OAUTH2 mode requesting a local Identity Provider (like Keycloak) which in turn, queries an LDAP Directory.

