# (c) cavaliba.com - sirene - models.py

from django.db import models
from django.utils import timezone
from django.utils.translation import gettext_lazy as _

# ---------------------------------------
# SMS Journal
# ---------------------------------------

class SMSJournal(models.Model):

    created_at = models.DateTimeField(_('Created at'), auto_now_add=True, db_index=True)   # , default=datetime.now
    created_by = models.CharField(_('Created by'), max_length=200, blank=True)
    mobile     = models.CharField(_('Mobile'), max_length=32, null=True, blank=True)
    content    = models.TextField(_('Content'), max_length=5000, blank=True)
    quota      = models.IntegerField(_('Quota left'), null=True, blank=True)

    class Meta:
        ordering = ['created_at']
        verbose_name = "SMS Journal"
        verbose_name_plural = "SMS Journal"

    def __str__(self):
        return f"{self.created_at} - {self.mobile}"
