---
title: Detailed Setup
description: Initial instructions to get started fast
weight: 20
---


## Prerequisite : setup docker

You need a docker available environment. You can skip this part if your docker environment is already setup.

You don't have to provide other middleware such as a web server, database server, etc. They are provided as docker containers within the Cavaliba stack.

For example, on a Linux Debian fresh install such as a Virtual Machine or a Desktop  you may have to perform the following actions:

```shell
## Debian

$ sudo apt-get update
$ sudo apt-get install ca-certificates curl
$ sudo install -m 0755 -d /etc/apt/keyrings
$ sudo curl -fsSL https://download.docker.com/linux/debian/gpg -o /etc/apt/keyrings/docker.asc
$ sudo chmod a+r /etc/apt/keyrings/docker.asc

$ echo   "deb [arch=$(dpkg --print-architecture) signed-by=/etc/apt/keyrings/docker.asc] https://download.docker.com/linux/debian \
       $(. /etc/os-release && echo "$VERSION_CODENAME") stable" |   sudo tee /etc/apt/sources.list.d/docker.list > /dev/null

$ sudo apt-get update
$ sudo apt-get install docker-ce docker-ce-cli containerd.io docker-buildx-plugin docker-compose-plugin

$ sudo groupadd docker
$ sudo usermod -aG docker $USER
$ newgrp docker

$ sudo systemctl enable docker.service
$ sudo systemctl enable containerd.service

```

On Ubuntu :

```shell
## Ubuntu

$ sudo apt-get update
$ sudo apt-get install ca-certificates curl
$ sudo install -m 0755 -d /etc/apt/keyrings

$ sudo curl -fsSL https://download.docker.com/linux/ubuntu/gpg -o /etc/apt/keyrings/docker.asc
$ sudo chmod a+r /etc/apt/keyrings/docker.asc

$ echo \
  "deb [arch=$(dpkg --print-architecture) signed-by=/etc/apt/keyrings/docker.asc] https://download.docker.com/linux/ubuntu \
  $(. /etc/os-release && echo "${UBUNTU_CODENAME:-$VERSION_CODENAME}") stable" | \
  sudo tee /etc/apt/sources.list.d/docker.list > /dev/null

$ sudo apt-get update
$ sudo apt-get install docker-ce docker-ce-cli containerd.io docker-buildx-plugin docker-compose-plugin

$ sudo groupadd docker
$ sudo usermod -aG docker $USER
$ newgrp docker

$ sudo systemctl enable docker.service
$ sudo systemctl enable containerd.service
```

To test your installation:
```shell
$ docker version
$ docker run hello-world
```
If you see dcoker versions, and a Docker Hello world message, everything is fine. The Hello-World image was downloded and started successfully on your host.


## Get Cavaliba release

In your working directory, enter the following command to download cavaliba 
from the public repository ; choose appropriate version. In doubt, use highest number for the latest release.

```bash
$ cd myworkdir/
$ wget https://cavaliba.com/download/cavaliba/latest.tar.gz
$ tar zxvf latest.tar.gz
```
You should see a new `3.17.1/` directory with startup files, source code, and empty data folders. Exact version number may vary.

To check downloaded content:	

```shell
$ cd 3.17.1  


$ tree -L 1
├── LICENSE
├── README.md
├── files/                       <= files in/out with Cavaliba (import, mail, ...)
├── source/                      <= source code
├── docker-compose.yml           <= docker starter
├── env.template                 <= cavaliba configuration template
└── nginx.conf                   <= logo/ and custom web templates

```



## Adapt Docker env template

```bash
$ cp env.template .env
```

Don't forget the dot at the beginning of the `.env` filename.


This is the only file you need to customize to get started quickly.

The `.env`file contains important parameters such as passwords and security items needed to start the application.

Edit the relevant part in this newly created `.env` file like this:


```
$ vi .env

CAVALIBA_DOCKER_IMAGE=cavaliba/cavaliba:3.17.1         <= upgrade later here

# Network : root FQDN/URL for *your* Cavaliba
CAVALIBA_CSRF_TRUSTED_ORIGINS="http://127.0.0.1:8000"  <= HERE, set your FQDN and port
CAVALIBA_PORT=8000                                     <= HERE, set your http port on your host ; 80, 8000, 8080, ...

# admin user (initial)
CAVALIBA_ADMIN_PASSWORD=change_again                   <= HERE, set a cavaliba app 'admin' built-in account inital password
CAVALIBA_ADMIN_EMAIL=admin@mydomain.com 

# Database
CAVALIBA_DB_USER=cavaliba                              <= you can use root ; then first launch must be repeated twice
CAVALIBA_DB_PASSWORD=changeme_please                   <= HERE, set a password for the internal cavaliba Database
CAVALIBA_DB_ROOT_PASSWORD=changeme_please_also         <= HERE, set a different password for the DB root account

CAVALIBA_DB_ENGINE=django.db.backends.mysql
CAVALIBA_DB_HOST=cavaliba_db                           <= container name ; change if external DB used!
CAVALIBA_DB_PORT=3306
CAVALIBA_DB_DATABASE=cavaliba


# Encryption key for sensitive fields in DB
CAVALIBA_CIPHER_KEY="Change me. Please..."             <= set an encryption key for sensistive DB content. Keep it safe.

# Frmaework & Cookie protection
CAVALIBA_SECRET_KEY=changeme_with_a_long_string
CAVALIBA_ALLOWED_HOSTS="localhost 127.0.0.1 *"
```

## Start the application

Once the `.env` file is ready you may start cavaliba as follow:

    $ docker compose up

You may later add a `-d` option to run docker in the background.

You may observe the different startup steps:

* download of various docker images : nginx, mariadb, redis, and cavaliba (from Docker Hub)
* mariadb database initial creation and startup
* redis cache server startup
* cavaliba async tasks container startup (celery)
* cavaliba app container startup (init app, translations, admin account update, DB migrations, etc.)
* web server startup (nginx)


Inspect the result like this (truncated) :

```shell
$ docker ps
IMAGE                  (...) STATUS                    PORTS                      NAMES
nginx:1.25.2                Up 10 seconds             0.0.0.0:8000->80/tcp       cavaliba_nginx
cavaliba/cavaliba:3.10      Up 10 seconds             8001/tcp                   cavaliba_app
cavaliba/cavaliba:3.10      Up 10 seconds                                        cavaliba_celery
redis:7.0.2-alpine3.16      Up 13 seconds (healthy)   6379/tcp                   cavaliba_redis
mariadb:10.10               Up 13 seconds (healthy)   3306/tcp                   cavaliba_db

```

You'll notice a new `db` folder in your `cavaliba/` main folder. It contains the (persistent) database content.

## Connect and sign-in with admin account

Open your browser to your host / port combination :

	firefox http://myhost:8000/home/private/


You'll presented with the sign-in screen. Use the `admin`built-in account, with the password you provided in the `.env` file.


## Setup usefull alias

    $ alias cavaliba  = "docker exec -it cavaliba_app python manage.py cavaliba"
    $ alias cavmanage = "docker exec -it cavaliba_app python manage.py"

Add them to your `~/.basrc` for persistence.

You can now type : 

    $ cavmanage
    $ cavaliba --help

    
## If anything went wrong

Check running containers:

     docker ps -a

Check logs for error messages:

     docker logs -f cavaliba_nginx
     docker logs -f cavaliba_app
     docker logs -f cavaliba_celery
     docker logs -f cavaliba_db
     docker logs -f cavaliba_redis


CSRF error message in the app ?

     verify the .env file and the CAVALIBA CSRF_ALLOWED_HOSTS value

Error in sign-in Web form

     double-check your admin password in the .env file



## What to do next ?

You may :

* have a quick tour of the application including importing demo data

* go to additional setup : configuration, authentication, TLS/SSL, permissions, backups, emails, sms, etc.
