# (c) cavaliba.com - data - permissions.py



def is_user_in_group(aaa=None, gname=None):

    if gname in aaa["groups"] + aaa["groups_indirect"]:
        return True
    return False


def aaa_perms_valid(aaa):
    try:
        if type(aaa["perms"]) is not list:
            return False
    except:
        return False
    return True

# -- schema

def has_schema_delete_permission(aaa=None):
    if not aaa_perms_valid(aaa):
        return False
    if "p_schema_delete" in aaa["perms"]:
        return True
    return False

def has_schema_update_permission(aaa=None):
    if not aaa_perms_valid(aaa):
        return False
    if "p_schema_update" in aaa["perms"]:
        return True
    return False

def has_schema_create_permission(aaa=None):
    if not aaa_perms_valid(aaa):
        return False
    if "p_schema_create" in aaa["perms"]:
        return True
    return False

def has_schema_read_permission(aaa=None):
    if not aaa_perms_valid(aaa):
        return False
    if "p_schema_read" in aaa["perms"]:
        return True
    return False

# -- schema field

def has_schemafield_delete_permission(aaa=None):
    if not aaa_perms_valid(aaa):
        return False
    if "p_schemafield_delete" in aaa["perms"]:
        return True
    return False

def has_schemafield_update_permission(aaa=None):
    if not aaa_perms_valid(aaa):
        return False
    if "p_schemafield_update" in aaa["perms"]:
        return True
    return False

def has_schemafield_create_permission(aaa=None):
    if not aaa_perms_valid(aaa):
        return False
    if "p_schemafield_create" in aaa["perms"]:
        return True
    return False

def has_schemafield_read_permission(aaa=None):
    if not aaa_perms_valid(aaa):
        return False
    if "p_schemafield_read" in aaa["perms"]:
        return True
    return False


# -- data read

def has_read_permission_on_class(aaa=None, classobj=None):
    # classobj is a DB object
    if not aaa_perms_valid(aaa):
        return False
    if not classobj:
        return False
    # global p_data_admin
    if "p_data_admin" in aaa["perms"]:
        return True
    # p_admin on classobj
    if classobj.p_admin:
        if classobj.p_admin in aaa["perms"]:
            return True
    # p_read on single class rules
    if classobj.p_read:
        if classobj.p_read in aaa["perms"]:
            return True
        else:
            return False
    
    # default to all-class permission
    if "p_data_read" in aaa["perms"]:
        return True

    return False


# -- data delete

def has_delete_permission_on_class(aaa=None, classobj=None):
    # classobj is a DB object

    if not aaa_perms_valid(aaa):
        return False   
    if not classobj:
        return False

    # global p_data_admin: allow all on data
    if "p_data_admin" in aaa["perms"]:
        return True

    # p_admin on classobj : allow all on this class
    if classobj.p_admin:
        if classobj.p_admin in aaa["perms"]:
            return True

    # if defined, single class permission rules
    if classobj.p_delete:
        if classobj.p_delete in aaa["perms"]:
            return True
        else:
            return False

    # default: check  all-class permission
    if "p_data_delete" in aaa["perms"]:
        return True

    return False



# -- data edit / update

def has_edit_permission_on_class(aaa=None, classobj=None):
    # classobj is a DB object

    if not aaa_perms_valid(aaa):
        return False
    if not classobj:
        return False

    # global p_data_admin: allow all on data / no override
    if "p_data_admin" in aaa["perms"]:
        return True

    # p_admin on classobj : allow all on this class / no override
    if classobj.p_admin:
        if classobj.p_admin in aaa["perms"]:
            return True

    #  single class permission rules if defined
    if classobj.p_update:
        if classobj.p_update in aaa["perms"]:
            return True
        else:
            return False
    
    # default: to all-class permission
    if "p_data_update" in aaa["perms"]:
        return True

    return False


# -- data create new instance

def has_create_permission_on_class(aaa=None, classobj=None):
    # classobj is a DB object

    if not aaa_perms_valid(aaa):
        return False
    
    if not classobj:
        return False

    # global p_data_admin: allow all on DATA / no override
    if "p_data_admin" in aaa["perms"]:
        return True

    # classlevel p_admin if defined : allow all on this class / no override
    if classobj.p_admin:
        if classobj.p_admin in aaa["perms"]:
            return True

    # if defined for this class, rules 
    if classobj.p_create:
        if classobj.p_create in aaa["perms"]:
            return True
        else:
            return False
    
    # default: global create permission on all classes
    if "p_data_create" in aaa["perms"]:
        return True

    return False



# ----
# IAM
# ----
def has_iam_export_permission(aaa=None):
    if not aaa_perms_valid(aaa):
        return False
    if 'p_iam_export' in aaa['perms']:
        return True
    return False

# user read
def has_user_read_permission(aaa=None):
    if not aaa_perms_valid(aaa):
        return False
    if 'p_user_read' in aaa['perms']:
        return True
    return False
# user create
def has_user_create_permission(aaa=None):
    if not aaa_perms_valid(aaa):
        return False
    if 'p_user_create' in aaa['perms']:
        return True
    return False
# user update
def has_user_update_permission(aaa=None):
    if not aaa_perms_valid(aaa):
        return False
    if 'p_user_update' in aaa['perms']:
        return True
    return False
# user delete
def has_user_delete_permission(aaa=None):
    if not aaa_perms_valid(aaa):
        return False
    if 'p_user_delete' in aaa['perms']:
        return True
    return False

# group read
def has_group_read_permission(aaa=None):
    if not aaa_perms_valid(aaa):
        return False
    if 'p_group_read' in aaa['perms']:
        return True
    return False
# group create
def has_group_create_permission(aaa=None):
    if not aaa_perms_valid(aaa):
        return False
    if 'p_group_create' in aaa['perms']:
        return True
    return False
# group update
def has_group_update_permission(aaa=None):
    if not aaa_perms_valid(aaa):
        return False
    if 'p_group_update' in aaa['perms']:
        return True
    return False
# group delete
def has_group_delete_permission(aaa=None):
    if not aaa_perms_valid(aaa):
        return False
    if 'p_group_delete' in aaa['perms']:
        return True
    return False

# role read
def has_role_read_permission(aaa=None):
    if not aaa_perms_valid(aaa):
        return False
    if 'p_role_read' in aaa['perms']:
        return True
    return False
# role create
def has_role_create_permission(aaa=None):
    if not aaa_perms_valid(aaa):
        return False
    if 'p_role_create' in aaa['perms']:
        return True
    return False
# role update
def has_role_update_permission(aaa=None):
    if not aaa_perms_valid(aaa):
        return False
    if 'p_role_update' in aaa['perms']:
        return True
    return False
# role delete
def has_role_delete_permission(aaa=None):
    if not aaa_perms_valid(aaa):
        return False
    if 'p_role_delete' in aaa['perms']:
        return True
    return False


# permission read
def has_permission_read_permission(aaa=None):
    if not aaa_perms_valid(aaa):
        return False
    if 'p_permission_read' in aaa['perms']:
        return True
    return False
# permission create
def has_permission_create_permission(aaa=None):
    if not aaa_perms_valid(aaa):
        return False
    if 'p_permission_create' in aaa['perms']:
        return True
    return False
# permission update
def has_permission_update_permission(aaa=None):
    if not aaa_perms_valid(aaa):
        return False
    if 'p_permission_update' in aaa['perms']:
        return True
    return False
# permission delete
def has_permission_delete_permission(aaa=None):
    if not aaa_perms_valid(aaa):
        return False
    if 'p_permission_delete' in aaa['perms']:
        return True
    return False
