# tests app_sirene

from django.test import TestCase, override_settings
from django.test import TransactionTestCase
from django.urls import reverse

import app_home.cache as cache

from app_user.models import SireneUser, SireneGroup
from app_user.role import role_get_by_name

from app_sirene.sms import sms_check_valid_number


class AppSireneUserTest(TestCase):

    fixtures = ["test"]

    def setUp(self):
        cache.init()

        user = SireneUser.objects.create(login="unittest", firstname="unittestname")
        user.save()

        role = role_get_by_name("role_sirene_user")
        role.users.add(user)
        role.save()


# class AppSireneUserTest(TransactionTestCase):

#     @classmethod
#     def setUpClass(cls):

#         super().setUpClass()
        
#         cavaliba_update(verbose=False)

#         user = SireneUser.objects.create(login="unittest", firstname="unittestname")
#         user.save()

#         role = role_get_by_name("role_sirene_user")
#         role.users.add(user)
#         role.save()


    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_user_public(self):
        response = self.client.get(reverse('app_sirene:index'))
        self.assertEqual(response.status_code, 200)

    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_user_anonymous(self):
        response = self.client.get(reverse('app_sirene:anonymous'))
        self.assertEqual(response.status_code, 200)

    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_user_private(self):
        response = self.client.get(reverse('app_sirene:private'))
        self.assertEqual(response.status_code, 200)

    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_user_history(self):
        response = self.client.get(reverse('app_sirene:history'))
        self.assertEqual(response.status_code, 200)


# Denied

    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_user_message_editor(self):
        response = self.client.get(reverse('app_sirene:message_editor'))
        self.assertEqual(response.status_code, 302)


# -- flush all GET/POST
    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_user_flushall_get(self):
        response = self.client.post(reverse('app_sirene:flushall'), follow=True)
        a = ('/sirene/', 302)
        #print(response.redirect_chain)
        self.assertTrue( a in response.redirect_chain)
        
