# (c) cavaliba.com - test_data 

from django.test import TestCase, override_settings
from django.test import TransactionTestCase
from django.urls import reverse

from app_home.home import cavaliba_update
from app_home.configuration import get_configuration

import app_home.cache as cache

from app_data.models import DataClass
from app_data.models import DataSchema
from app_data.models import DataInstance

from app_data.data import Instance


class TestDataClass(TestCase):
    
    fixtures = ["test"]

    # @classmethod
    # def setUpTestData(cls):
    #     #print("setUpTestData: Run once to set up non-modified data for all class methods.")
    #     pass

    def setUp(self):
        #print("setUp: Run once for every test method to setup clean data.")
        cache.init()
        

    def test_has_apikey(self):
        classobj = DataClass.objects.get(keyname='_apikey')
        self.assertIsNotNone(classobj)
        self.assertEqual(classobj.is_enabled, True)      

    def test_has_enumerate(self):
        classobj = DataClass.objects.get(keyname='_enumerate')
        self.assertIsNotNone(classobj)
        self.assertEqual(classobj.is_enabled, True)      

    def test_has_pipeline(self):
        classobj = DataClass.objects.get(keyname='_pipeline')
        self.assertIsNotNone(classobj)
        self.assertEqual(classobj.is_enabled, True)      

    def test_has_dataview(self):
        classobj = DataClass.objects.get(keyname='_dataview')
        self.assertIsNotNone(classobj)
        self.assertEqual(classobj.is_enabled, True)      


    def test_has_site(self):
        classobj = DataClass.objects.get(keyname='site')
        self.assertIsNotNone(classobj)
        self.assertEqual(classobj.is_enabled, True)


    def test_has_app(self):
        classobj = DataClass.objects.get(keyname='app')
        self.assertIsNotNone(classobj)
        self.assertEqual(classobj.is_enabled, True)

    def test_has_sitegroup(self):
        classobj = DataClass.objects.get(keyname='sitegroup')
        self.assertIsNotNone(classobj)
        self.assertEqual(classobj.is_enabled, True)

    def test_has_customer(self):
        classobj = DataClass.objects.get(keyname='customer')
        self.assertIsNotNone(classobj)
        self.assertEqual(classobj.is_enabled, True)


    def test_has_test1(self):
        classobj = DataClass.objects.get(keyname='test1')
        self.assertIsNotNone(classobj)
        self.assertEqual(classobj.is_enabled, True)

    def test_has_test2(self):
        classobj = DataClass.objects.get(keyname='test2')
        self.assertIsNotNone(classobj)
        self.assertEqual(classobj.is_enabled, True)

    def test_has_test3(self):
        classobj = DataClass.objects.get(keyname='test3')
        self.assertIsNotNone(classobj)
        self.assertEqual(classobj.is_enabled, True)

    def test_has_test4(self):
        classobj = DataClass.objects.get(keyname='test4')
        self.assertIsNotNone(classobj)
        self.assertEqual(classobj.is_enabled, True)


# class TestDataSchema(TestCase):
    
#     fixtures = ["test"]

#     # @classmethod
#     # def setUpTestData(cls):
#     #     #print("setUpTestData: Run once to set up non-modified data for all class methods.")
#     #     pass

#     def setUp(self):
#         #print("setUp: Run once for every test method to setup clean data.")
#         cache.init()

    def test_schema_count(self):

        DEFAULT = {
            'app':2,
            'site':3,
            'customer':2,
            'sitegroup':4,
            'test1':22,
            'test2':1,
            'test3':2,
            'test4':2,
            '_apikey':12,
            '_enumerate':2,
            '_dataview': 3,
            '_pipeline':2,

        }

        for classname,schemacount in DEFAULT.items():
            classobj = DataClass.objects.get(keyname=classname)
            count = DataSchema.objects.filter(classobj=classobj).count()
            self.assertEqual(count, schemacount)



    def test_field_values(self):

        instance = Instance(classname="test1", iname="test1-01", expand=False)
        self.assertIsNotNone(instance)
        self.assertEqual(instance.fields["mystring"].get_value(),["data for test1-01"])
        self.assertEqual(instance.fields["myint"].get_value(),[11])
        self.assertEqual(instance.fields["myfloat"].get_value(),[27.19])
        self.assertEqual(instance.fields["myboolean"].get_value(),[True])
        self.assertEqual(instance.fields["mydate"].get_value(),["2024-11-01"])
        self.assertEqual(instance.fields["myipv4"].get_value(),["10.1.2.3"])
        self.assertEqual(instance.fields["my_schema_test0"].get_value(),["test0-01"])
        self.assertEqual(instance.fields["my_schema_test0_multi"].get_value(),["test0-02","test0-03"])
        self.assertEqual(instance.fields["my_schema_self"].get_value(),["test1-03"])


    def test_external_no_expand(self):

        instance = Instance(classname="test4", iname="test4-01", expand=False)
        self.assertIsNotNone(instance)
        self.assertIsNotNone(instance.fields["_test1"])
        self.assertFalse("test1" in instance.fields)


    def test_external_expand(self):

        instance = Instance(classname="test4", iname="test4-01", expand=True)
        self.assertIsNotNone(instance)
        self.assertIsNotNone(instance.fields["_test1"])
        self.assertIsNotNone(instance.fields["test1"])
        self.assertIsNotNone(instance.fields["test1__mystring"])
        self.assertIsNotNone(instance.fields["test1__myint"])
        self.assertIsNotNone(instance.fields["test1__myfloat"])
        self.assertIsNotNone(instance.fields["test1__myboolean"])
        self.assertEqual(instance.fields["test1__myint"].get_value(),[11])
        self.assertEqual(instance.fields["test1__myfloat"].get_value(),[27.19])
        self.assertEqual(instance.fields["test1__myboolean"].get_value(),[True])
        self.assertEqual(instance.fields["test1__mystring"].get_value(),["data for test1-01"])


    def test_enumerate_no_expand(self):

        instance = Instance(classname="test1", iname="test1-01", expand=False)
        self.assertIsNotNone(instance)
        self.assertIsNotNone(instance.fields["my_enumerate_abcde"])
        self.assertEqual(instance.fields["my_enumerate_abcde"].get_value(),["A"])
        self.assertIsNotNone(instance.fields["my_enumerate_abcde_multi"])
        self.assertTrue("A" in instance.fields["my_enumerate_abcde_multi"].get_value())
        self.assertTrue("B" in instance.fields["my_enumerate_abcde_multi"].get_value())
        self.assertTrue("C" in instance.fields["my_enumerate_abcde_multi"].get_value())

        self.assertIsNotNone(instance.fields["my_enumerate_subfields"])
        self.assertEqual(instance.fields["my_enumerate_subfields"].get_value(),["A"])
        self.assertFalse("my_enumerate_subfields__widget" in instance.fields)
        self.assertFalse("my_enumerate_subfields__enumstring" in instance.fields)
        self.assertFalse("my_enumerate_subfields__enumint" in instance.fields)
        self.assertFalse("my_enumerate_subfields__enumfloat" in instance.fields)
        self.assertFalse("my_enumerate_subfields__enumboolean" in instance.fields)

    def test_enumerate_expand(self):

        instance = Instance(classname="test1", iname="test1-01", expand=True)
        self.assertIsNotNone(instance)
        self.assertIsNotNone(instance.fields["my_enumerate_abcde"])
        self.assertEqual(instance.fields["my_enumerate_abcde"].get_value(),["A"])
        self.assertIsNotNone(instance.fields["my_enumerate_abcde_multi"])
        self.assertTrue("A" in instance.fields["my_enumerate_abcde_multi"].get_value())
        self.assertTrue("B" in instance.fields["my_enumerate_abcde_multi"].get_value())
        self.assertTrue("C" in instance.fields["my_enumerate_abcde_multi"].get_value())

        self.assertIsNotNone(instance.fields["my_enumerate_subfields"])
        self.assertEqual(instance.fields["my_enumerate_subfields"].get_value(),["A"])
        self.assertTrue("my_enumerate_subfields__widget" in instance.fields)
        self.assertTrue("my_enumerate_subfields__enumstring" in instance.fields)
        self.assertTrue("my_enumerate_subfields__enumint" in instance.fields)
        self.assertTrue("my_enumerate_subfields__enumfloat" in instance.fields)
        self.assertTrue("my_enumerate_subfields__enumboolean" in instance.fields)

        self.assertEqual(instance.fields["my_enumerate_subfields__enumint"].get_value(), [111])
        self.assertEqual(instance.fields["my_enumerate_subfields__enumfloat"].get_value(), [111.1])
        self.assertEqual(instance.fields["my_enumerate_subfields__enumstring"].get_value(), ["AAA"])
        self.assertEqual(instance.fields["my_enumerate_subfields__enumboolean"].get_value(), [False])
        self.assertEqual(instance.fields["my_enumerate_subfields__widget"].get_value(), ["&#x1F7E2;"])


# my_enumerate_subfields__enumstring
#     from: my_enumerate_subfields : A
# - Widget:
#     from: my_enumerate_subfields__widget : green_circle
# - String:
#     from: my_enumerate_subfields__enumstring   : AAA
# - Boolean:
#     from: my_enumerate_subfields__enumboolean : False
# - Int:
#     from: my_enumerate_subfields__enumint : 111
# - Float:
#     from: my_enumerate_subfields__enumfloat : 111.1