# (c) cavaliba.com - home - cavaliba.py


# global framework version
CAVALIBA_VERSION = "3.15.4"

# Global True list string equivs
TRUE_LIST = ('on', 'On', 'ON', True, 'yes', 'Yes', 'YES', 'True', 'true', 'TRUE', 1, "1")




GLOBAL_BUILTIN_DATA = '''


# -----------------------------------------------------
# user
# -----------------------------------------------------

# admin built-in user - all permissions by default (in code)

- classname: _user
  keyname: admin
  displayname: Built-in Global Admin user

  
# ------------------------------------------------------
# permissions
# ------------------------------------------------------

# conf

- classname: _permission
  keyname: p_conf_view
  description: "Built-in conf view permission"
  displayname: p_conf_view
  is_builtin: True

- classname: _permission
  keyname: p_conf_admin
  description: "Built-in conf admin permission"
  displayname: "p_conf_admin"
  is_builtin: True

# log    

- classname: _permission
  keyname: p_log_view
  is_builtin: True
  description: "Built-in LOG view permission"
  displayname: "p_log_view"

- classname: _permission
  keyname: p_log_admin
  is_builtin: True
  description: "Built-in LOG admin permission"
  displayname: p_log_admin

# home 
  
- classname: _permission
  keyname: p_home_access
  is_builtin: True
  description: "Built-in HOME app Access"
  displayname: "p_home_access"

- classname: _permission
  keyname: p_home_update
  is_builtin: True
  description: "Built-in HOME update dashboard"
  displayname: "p_home_update"

- classname: _permission
  keyname: p_home_import
  is_builtin: True
  description: "Built-in HOME import"
  displayname: p_home_import

# --------------------
# IAM Permissions

- classname: _permission
  keyname: p_iam_admin
  is_builtin: True
  description: "Built-in IAM admin"
  displayname: ""


- classname: _permission
  keyname: p_iam_access
  is_builtin: True
  description: "Built-in IAM access"
  displayname: "p_iam_access"

- classname: _permission
  keyname: p_iam_impersonate
  is_builtin: True
  description: "Built-in IAM can impersonate other account"
  displayname: "p_iam_impersonate"

# -- user

- classname: _permission
  keyname: p_user_pref
  is_builtin: True
  description: "Built-in USER.preferences permission"
  displayname: ""

- classname: _permission
  keyname: p_user_email_test
  is_builtin: True
  description: "Built-in USER.test_email permission"
  displayname: ""

- classname: _permission
  keyname: p_user_sms_test
  is_builtin: True
  description: "Built-in USER.test_sms permission"
  displayname: ""

- classname: _permission
  keyname: p_user_debug
  is_builtin: True
  description: "Built-in USER.debug permission"
  displayname: ""

- classname: _permission
  keyname: p_user_read
  is_builtin: True
  description: "Built-in USER read permission"
  displayname: "p_user_read"

- classname: _permission
  keyname: p_user_create
  is_builtin: True
  description: "Built-in USER create permission"
  displayname: "p_user_create"

- classname: _permission
  keyname: p_user_update
  is_builtin: True
  description: "Built-in USER update permission"
  displayname: "p_user_update"

- classname: _permission
  keyname: p_user_delete
  is_builtin: True
  description: "Built-in USER delete permission"
  displayname: "p_user_delete"
    
- classname: _permission
  keyname: p_user_import
  is_builtin: True
  description: "Built-in USER import permission"
  displayname: ""

- classname: _permission
  keyname: p_user_export
  is_builtin: True
  description: "Built-in USER export permission"
  displayname: ""

  # -- group

- classname: _permission
  keyname: p_group_read
  is_builtin: True
  description: "Built-in GROUP read permission"
  displayname: "p_group_read"

- classname: _permission
  keyname: p_group_create
  is_builtin: True
  description: "Built-in GROUP create permission"
  displayname: "p_group_create"

- classname: _permission
  keyname: p_group_update
  is_builtin: True
  description: "Built-in GROUP update permission"
  displayname: "p_group_update"

- classname: _permission
  keyname: p_group_delete
  is_builtin: True
  description: "Built-in GROUP delete permission"
  displayname: "p_group_delete"
  
- classname: _permission
  keyname: p_group_import
  is_builtin: True
  description: "Built-in GROUP import permission"
  displayname: ""

- classname: _permission
  keyname: p_group_export
  is_builtin: True
  description: "Built-in GROUP export permission"
  displayname: ""

# -- role

- classname: _permission
  keyname: p_role_read
  is_builtin: True
  description: "Built-in IAM role read permission"
  displayname: p_role_read

- classname: _permission
  keyname: p_role_create
  is_builtin: True
  description: "Built-in IAM role create permission"
  displayname: p_role_create

- classname: _permission
  keyname: p_role_update
  is_builtin: True
  description: "Built-in IAM role update permission"
  displayname: p_role_update

- classname: _permission
  keyname: p_role_delete
  is_builtin: True
  description: "Built-in IAM role delete permission"
  displayname: p_role_delete
    

- classname: _permission
  keyname: p_role_import
  is_builtin: True
  description: "Built-in USER.role_import permission"
  displayname: ""

- classname: _permission
  keyname: p_role_export
  is_builtin: True
  description: "Built-in USER.role_export permission"
  displayname: ""

# -- permission

- classname: _permission
  keyname: p_permission_read
  is_builtin: True
  description: "Built-in IAM permission read permission"
  displayname: p_permission_read

- classname: _permission
  keyname: p_permission_create
  is_builtin: True
  description: "Built-in IAM permission create permission"
  displayname: p_permission_create

- classname: _permission
  keyname: p_permission_update
  is_builtin: True
  description: "Built-in IAM permission update permission"
  displayname: p_permission_update

- classname: _permission
  keyname: p_permission_delete
  is_builtin: True
  description: "Built-in IAM permission delete permission"
  displayname: p_permission_delete
    

- classname: _permission
  keyname: p_permission_import
  is_builtin: True
  description: "Built-in IAM permission import permission"
  displayname: p_permission_import

- classname: _permission
  keyname: p_permission_export
  is_builtin: True
  description: "Built-in IMA permission export permission"
  displayname: p_permission_export
  

# ---------------------
# Data PERMISSIONS

# dashboard access to DATA app
# ----------------------------
- classname: _permission
  keyname: p_data_access
  is_builtin: True
  description: "Built-in DATA dashboard access"
  displayname: "p_data_access"

  
- classname: _permission
  keyname: p_permission_edit
  is_builtin: True
  description: "Built-in PERMISSION edit"
  displayname: p_permission_edit

  
# schema / class definitions
# --------------------------

- classname: _permission
  keyname: p_schema_read
  is_builtin: True
  description: "Built-in SCHEMA read"
  displayname: "p_schema_read"

- classname: _permission
  keyname: p_schema_create
  is_builtin: True
  description: "Built-in SCHEMA create"
  displayname: "p_schema_create"

- classname: _permission
  keyname: p_schema_update
  is_builtin: True
  description: "Built-in SCHEMA update"
  displayname: "p_schema_update"

- classname: _permission
  keyname: p_schema_delete
  is_builtin: True
  description: "Built-in SCHEMA delete"
  displayname: "p_schema_delete"


- classname: _permission
  keyname: p_schema_import
  is_builtin: True
  description: "Built-in SCHEMA import"
  displayname: "p_schema_import"

- classname: _permission
  keyname: p_schema_export
  is_builtin: True
  description: "Built-in SCHEMA export"
  displayname: p_schema_export

  
# all data classes + not blockable
# ---------------------------------
# special / non-blocking downwards

- classname: _permission
  keyname: p_data_admin
  is_builtin: True
  description: "Built-in DATA all permissions non-blocking"
  displayname: "p_data_admin"

# all data classes if not blocked at class level
# ----------------------------------------------

- classname: _permission
  keyname: p_data_read
  is_builtin: True
  description: "Built-in DATA read all"
  displayname: "p_data_read"

- classname: _permission
  keyname: p_data_create
  is_builtin: True
  description: "Built-in DATA create all"
  displayname: "p_data_create"

- classname: _permission
  keyname: p_data_update
  is_builtin: True
  description: "Built-in DATA update all"
  displayname: "p_data_update"

- classname: _permission
  keyname: p_data_delete
  is_builtin: True
  description: "Built-in DATA delete all"
  displayname: "p_data_delete"

- classname: _permission
  keyname: p_data_import
  is_builtin: True
  description: "Built-in DATA import all"
  displayname: "p_data_import"

- classname: _permission
  keyname: p_data_export
  is_builtin: True
  description: "Built-in DATA export all"
  displayname: p_data_export

  
    

# -------------------------------------------------------------
# ROLES
# -------------------------------------------------------------

# role_admin - all permissions by default (code)

- classname: _role
  keyname: role_admin
  displayname: Built-in Global Admin role
  is_builtin: true
  users:
    - admin
    

# role default

- classname: _role
  keyname: role_default
  is_builtin: True
  displayname: Built-in Default role for new users/anonymous/visitors
  permissions:
    - p_sirene_access
    - p_sirene_history
    - p_sirene_detail

# role_home_admin

- classname: _role
  keyname: role_home_admin
  displayname: Built-in HOME Admin Role
  is_builtin: true
  permissions:
    - p_home_access
    - p_home_update
    - p_home_import

# role_home_access

- classname: _role
  keyname: role_home_access
  displayname: Built-in HOME User Role
  is_builtin: true
  permissions:
    - p_home_access

    
# ------------
# IAM Roles

- classname: _role
  keyname: role_iam_admin
  is_builtin: True
  displayname: Built-in IAM ADMIN Role
  permissions: 
    - p_iam_access
    - p_iam_admin
    - p_user_pref
    - p_user_email_test
    - user_sms_test
    - p_user_debug
    - p_user_read
    - p_user_create
    - p_user_update
    - p_user_delete
    - p_user_import
    - p_user_export
    - p_group_read
    - p_group_create
    - p_group_update
    - p_group_delete
    - p_group_import
    - p_group_export
    - p_role_read
    - p_role_create
    - p_role_update
    - p_role_delete
    - p_role_import
    - p_role_export
    - p_permission_read
    - p_permission_create
    - p_permission_update
    - p_permission_delete
    - p_permission_import
    - p_permission_export


- classname: _role
  keyname: role_user_rw
  is_builtin: True
  displayname: Built-in IAM RW Role
  permissions: 
    - p_iam_access
    - p_user_pref
    - p_user_email_test
    - user_sms_test
    - p_user_debug
    - p_user_read
    - p_user_create
    - p_user_update
    - p_user_delete
    - p_user_import
    - p_user_export
    - p_group_read
    - p_group_create
    - p_group_update
    - p_group_delete
    - p_group_import
    - p_group_export
    - p_role_read


- classname: _role
  keyname: role_user_ro
  is_builtin: True
  displayname: Built-in USER RO Role
  permissions: 
    - p_iam_access
    - p_user_pref
    - p_user_debug
    - p_user_read
    - p_group_read


- classname: _role
  keyname: role_group_ro
  is_builtin: True
  displayname: Built-in USER Group RO Role
  permissions: 
    - p_iam_access
    - p_user_read
    - p_group_read

- classname: _role
  keyname: role_group_rw
  is_builtin: True
  displayname: Built-in USER Group RW Role
  permissions: 
    - p_iam_access
    - p_user_read
    - p_group_read
    - p_group_create
    - p_group_update
    - p_group_delete
    - p_group_import
    - p_group_export


- classname: _role
  keyname: role_role_ro
  is_builtin: True
  displayname: Built-in USER RO Role
  permissions: 
    - p_iam_access
    - p_user_read
    - p_group_read
    - p_permission_read
    - p_role_read

- classname: _role
  keyname: role_role_rw
  is_builtin: True
  displayname: Built-in USER RW Role
  permissions: 
    - p_iam_access
    - p_user_read
    - p_group_read
    - p_role_read
    - p_role_create
    - p_role_update
    - p_role_delete
    - p_role_import
    - p_role_export
    - p_permission_read
    - p_permission_export


- classname: _role
  keyname: role_security_audit
  is_builtin: True
  displayname: Built-in USER Security RO Role
  permissions: 
    - p_iam_access
    - p_user_pref
    - p_user_email_test
    - user_sms_test
    - p_user_debug
    - p_user_read
    - p_user_export
    - p_group_read
    - p_group_export
    - p_role_read
    - p_role_export
    - p_permission_read
    - p_permission_export


- classname: _role
  keyname: role_security_admin
  is_builtin: True
  displayname: Built-in USER Security RW Role
  permissions: 
    - p_iam_access
    - p_iam_admin
    - p_user_pref
    - p_user_email_test
    - user_sms_test
    - p_user_debug
    - p_user_read
    - p_user_create
    - p_user_update
    - p_user_delete
    - p_user_import
    - p_user_export
    - p_group_read
    - p_group_create
    - p_group_update
    - p_group_delete
    - p_group_import
    - p_group_export
    - p_role_read
    - p_role_create
    - p_role_update
    - p_role_delete
    - p_role_import
    - p_role_export
    - p_permission_read
    - p_permission_create
    - p_permission_update
    - p_permission_delete
    - p_permission_import
    - p_permission_export

    
# --------------------
# Data ROLES

- classname: _role
  keyname: role_schema_admin
  displayname: Built-in SCHEMA admin role
  is_builtin: true
  permissions:
      - p_data_access
      - p_schema_read
      - p_schema_create
      - p_schema_delete
      - p_schema_update
      - p_schema_export
      - p_schema_import

- classname: _role
  keyname: role_data_admin
  displayname: Built-in DATA admin role
  is_builtin: true
  permissions:
      - p_schema_read
      - p_data_access
      - p_data_admin
      - p_permission_edit

- classname: _role
  keyname: role_data_read
  displayname: Built-in DATA read role
  is_builtin: true
  permissions:
      - p_data_access
      - p_data_read

- classname: _role
  keyname: role_data_create
  displayname: Built-in DATA create role
  is_builtin: true
  permissions:
      - p_data_access
      - p_data_read
      - p_data_create

- classname: _role
  keyname: role_data_update
  displayname: Built-in DATA update role
  is_builtin: true
  permissions:
      - p_data_access
      - p_data_read
      - p_data_update

- classname: _role
  keyname: role_data_delete
  displayname: Built-in DATA delete role
  is_builtin: true
  permissions:
      - p_data_access
      - p_data_read
      - p_data_delete





# -------------------
# schema: - API Keys 
# -------------------

- classname: _permission
  keyname: p_apikey_admin
  is_builtin: True
  description: "Built-in APIKEY admin permission"
  displayname: "p_apikey_admin"

- classname: _permission
  keyname: p_apikey_create
  is_builtin: True
  description: "Built-in APIKEY create permission"
  displayname: p_apikey_create

- classname: _permission
  keyname: p_apikey_read
  is_builtin: True
  description: "Built-in APIKEY read permission"
  displayname: p_apikey_read

- classname: _permission
  keyname: p_apikey_update
  is_builtin: True
  description: "Built-in APIKEY update permission"
  displayname: p_apikey_update
      
- classname: _permission
  keyname: p_apikey_delete
  is_builtin: True
  description: "Built-in APIKEY delete permission"
  displayname: p_apikey_delete

- classname: _permission
  keyname: p_apikey_import
  is_builtin: True
  description: "Built-in APIKEY import permission"
  displayname: p_apikey_import

- classname: _permission
  keyname: p_apikey_export
  is_builtin: True
  description: "Built-in APIKEY export permission"
  displayname: p_apikey_export
      

- classname: _schema
  keyname: _apikey
  #_action: init
  displayname: API Keys
  is_enabled: yes
  icon: fa-key
  order: 820
  page: Internal
  handle_method: md5
  p_admin: p_apikey_admin
  p_create: p_apikey_create
  p_read: p_apikey_read
  p_update: p_apikey_update
  p_delete: p_apikey_delete
  p_import: p_apikey_import
  p_export: p_apikey_export
  keyvalue:
        displayname: Secret
        order: 50
        dataformat: string
  description:
        displayname: Description
        order: 60
        dataformat: string
        default : "API Key"
  is_readonly:
        displayname: Read-Only
        dataformat: boolean
        order: 70
        default: true
  permissions:
        order: 80
        displayname: Permissions
        dataformat: text
  not_after:
        displayname: Not After
        description: format YYYY-MM-DD
        dataformat: date
  time_filter:
        displayname: Time Filter
        dataformat: text
  ip_filter:
        displayname: IP Filter
        dataformat: text
        default : "*"
  acl_filter:
        displayname: ACL Filter
        cardinal_max: 0
        dataformat: text
  last_success:
        displayname: Last Success
        description: format YYYY-MM-DD
        dataformat: date
  last_error:
        displayname: Last Error
        description: format YYYY-MM-DD
        dataformat: date
  success_count:
        displayname: Success Count
        dataformat: int
  error_count:
        displayname: Error Count
        dataformat: int



      
# -------------------
# schema: enumerate
# -------------------

- classname: _permission
  keyname: p_enumerate_admin
  is_builtin: True
  description: "Built-in enumerate admin permission"
  displayname: "p_enumerate_admin"

- classname: _permission
  keyname: p_enumerate_create
  is_builtin: True
  description: "Built-in enumerate create permission"
  displayname: p_enumerate_create

- classname: _permission
  keyname: p_enumerate_read
  is_builtin: True
  description: "Built-in enumerate read permission"
  displayname: p_enumerate_read

- classname: _permission
  keyname: p_enumerate_update
  is_builtin: True
  description: "Built-in enumerate update permission"
  displayname: p_enumerate_update
      
- classname: _permission
  keyname: p_enumerate_delete
  is_builtin: True
  description: "Built-in enumerate delete permission"
  displayname: p_enumerate_delete

- classname: _permission
  keyname: p_enumerate_import
  is_builtin: True
  description: "Built-in enumerate import permission"
  displayname: p_enumerate_import

- classname: _permission
  keyname: p_enumerate_export
  is_builtin: True
  description: "Built-in enumerate export permission"
  displayname: p_enumerate_export

- classname: _schema
  keyname: _enumerate
  #_action: init
  displayname: Data Enumerates
  is_enabled: yes
  icon: fa-table
  order: 810
  page: Internal
  handle_method: md5
  p_admin: p_enumerate_admin
  p_create: p_enumerate_create
  p_read: p_enumerate_read
  p_update: p_enumerate_update
  p_delete: p_enumerate_delete
  p_import: p_enumerate_import
  p_export: p_enumerate_export

  description:
    displayname: Description
    order: 100
    dataformat: string
  content:
    displayname: Content
    page: input
    order: 120
    dataformat: text
    dataformat_ext: yaml 


# -------------------
# schema: pipeline
# -------------------

- classname: _permission
  keyname: p_pipeline_admin
  is_builtin: True
  description: "Built-in pipeline admin permission"
  displayname: "p_pipeline_admin"

- classname: _permission
  keyname: p_pipeline_create
  is_builtin: True
  description: "Built-in pipeline create permission"
  displayname: p_pipeline_create

- classname: _permission
  keyname: p_pipeline_read
  is_builtin: True
  description: "Built-in pipeline read permission"
  displayname: p_pipeline_read

- classname: _permission
  keyname: p_pipeline_update
  is_builtin: True
  description: "Built-in pipeline update permission"
  displayname: p_pipeline_update
      
- classname: _permission
  keyname: p_pipeline_delete
  is_builtin: True
  description: "Built-in pipeline delete permission"
  displayname: p_pipeline_delete

- classname: _permission
  keyname: p_pipeline_import
  is_builtin: True
  description: "Built-in pipeline import permission"
  displayname: p_pipeline_import

- classname: _permission
  keyname: p_pipeline_export
  is_builtin: True
  description: "Built-in pipeline export permission"
  displayname: p_pipeline_export

- classname: _schema
  keyname: _pipeline
  displayname: Data Pipelines
  is_enabled: yes
  icon: fa-gears
  order: 500
  page: Internal
  handle_method: md5
  p_admin: p_pipeline_admin
  p_create: p_pipeline_create
  p_read: p_pipeline_read
  p_update: p_pipeline_update
  p_delete: p_pipeline_delete
  p_import: p_pipeline_import
  p_export: p_pipeline_export

  description:
    displayname: Description
    order: 100
    dataformat: string
  content:
    displayname: Content
    page: Content
    order: 100
    dataformat: text
    dataformat_ext: yaml

    

# -------------------
# schema: dataview
# -------------------

- classname: _permission
  keyname: p_dataview_admin
  is_builtin: True
  description: "Built-in dataview admin permission"
  displayname: "p_dataview_admin"

- classname: _permission
  keyname: p_dataview_create
  is_builtin: True
  description: "Built-in dataview create permission"
  displayname: p_dataview_create

- classname: _permission
  keyname: p_dataview_read
  is_builtin: True
  description: "Built-in dataview read permission"
  displayname: p_dataview_read

- classname: _permission
  keyname: p_dataview_update
  is_builtin: True
  description: "Built-in dataview update permission"
  displayname: p_dataview_update
      
- classname: _permission
  keyname: p_dataview_delete
  is_builtin: True
  description: "Built-in dataview delete permission"
  displayname: p_dataview_delete

- classname: _permission
  keyname: p_dataview_import
  is_builtin: True
  description: "Built-in dataview import permission"
  displayname: p_dataview_import

- classname: _permission
  keyname: p_dataview_export
  is_builtin: True
  description: "Built-in dataview export permission"
  displayname: p_dataview_export

- classname: _schema
  keyname: _dataview
  displayname: Data Views
  is_enabled: yes
  icon: fa-table
  order: 810
  page: Internal
  handle_method: md5
  p_admin: p_dataview_admin
  p_create: p_dataview_create
  p_read: p_dataview_read
  p_update: p_dataview_update
  p_delete: p_dataview_delete
  p_import: p_dataview_import
  p_export: p_dataview_export
  
  description:
    displayname: Description
    order: 100
    dataformat: string
  target_class:
    displayname: Schema
    order: 110
    dataformat: string
  content:
    displayname: Content
    order: 120
    dataformat: text
    dataformat_ext: yaml


# default Dataview for _dataview
# ------------------------------
- classname: _dataview
  keyname: _dataview_default
  target_class: _dataview
  displayname: Data View default
  is_enabled: true
  description: Default dataview for DataView
  content: |
    columns:
      - keyname
      - displayname
      - target_class
      - last_update



# -------------------------------------------------------------------
# _home Instances
# -------------------------------------------------------------------


# -- Services (100)

- classname: _home
  keyname: home
  #_action: ...
  displayname: Home Dashboard
  description: Main App
  icon: fa-home
  url: /home/private/
  #dashboard_section: 
  #sidebar_section:
  order: 100
  permission: p_home_access

# ---

- classname: _home
  keyname: sirene
  displayname: Sirene
  description: Sirene
  icon: fa-sun-o
  url: /sirene/private/
  dashboard_section: Services
  sidebar_section: Services
  order: 110
  permission: p_sirene_access


- classname: _home
  keyname: sms
  displayname: SMS Sarbacane
  description: Send SMS
  icon: fa-paper-plane
  url: /sirene/private/sms/send/
  dashboard_section: Services
  sidebar_section: Services
  order: 120
  permission: p_sirene_access


# ---- IAM (300)

- classname: _home
  keyname: user
  displayname: Users
  description: Users
  icon: fa-user-plus
  url: /user/private/users/
  order: 300
  dashboard_section: IAM
  sidebar_section: IAM
  permission: p_user_read

- classname: _home
  keyname: group
  displayname: Groups
  description: Groups
  icon: fa-users
  url: /user/private/groups/
  order: 310
  dashboard_section: IAM
  sidebar_section: IAM
  permission: p_group_read

- classname: _home
  keyname: role
  displayname: Roles
  description: Roles
  icon: fa-user-secret
  url: /user/private/roles/
  order: 320
  dashboard_section: IAM
  sidebar_section: IAM
  permission: p_role_read

- classname: _home
  keyname: permission
  displayname: Permissions
  description: Permissions
  icon: fa-key
  url: /user/private/permissions/
  order: 322
  dashboard_section: IAM
  sidebar_section: IAM
  permission: p_permission_read
  

# --- Data Management (500)

- classname: _home
  keyname: data_app
  displayname: Applications
  description: Applications
  icon: fa-firefox
  url: /data/private/c/app/list/
  dashboard_section: Data Management
  sidebar_section: Data Management
  order: 500
  permission: p_data_read

- classname: _home
  keyname: data_site
  displayname: Sites
  description: Sites
  icon: fa-hospital-o
  url: /data/private/c/site/list/
  dashboard_section: Data Management
  sidebar_section: Data Management
  order: 510
  permission: p_data_read

- classname: _home
  keyname: data_sitegroup
  displayname: Groups of Sites
  description: Groups of Sites
  icon: fa-university
  url: /data/private/c/sitegroup/list/
  dashboard_section: Data Management
  sidebar_section: Data Management
  order: 520
  permission: p_data_read

# ...

- classname: _home
  keyname: data
  displayname: "[+] Data Management"
  description: Data Management (all)
  icon: fa-database
  url: /data/private/
  dashboard_section: Data Management
  sidebar_section: Data Management
  order: 599
  permission: p_data_access


    
# --- Admin (900)

- classname: _home
  keyname: conf
  displayname: Configuration
  description: Configuration Management
  icon: fa-wrench
  url: /home/private/conf/
  order: 900
  dashboard_section: Admin
  sidebar_section: Admin
  permission: p_conf_access

# Logs

- classname: _home
  keyname: log
  displayname: Logs
  description: Audit trail
  icon: fa-list
  url: /home/private/log/
  dashboard_section: Admin
  sidebar_section: Admin
  order: 910
  permission: p_log_view

- classname: _home
  keyname: sms_stat
  displayname: SMS Stats
  description: SMS Stats
  icon: fa-list
  url: /sirene/private/sms/stat/
  dashboard_section: Admin
  sidebar_section: Admin
  order: 920
  permission: p_sirene_sms_stat

- classname: _home
  keyname: sms_journal
  displayname: SMS Journal
  description: SMS Journal
  icon: fa-list
  url: /sirene/private/sms/journal/
  dashboard_section: Admin
  sidebar_section: Admin
  order: 930
  permission: p_sirene_sms_journal

- classname: _home
  keyname: import
  displayname: Import
  description: Import tool
  icon: fa-plus
  url: /data/private/import/
  dashboard_section: Admin
  sidebar_section: Admin
  order: 940
  permission: p_data_import

- classname: _home
  keyname: export
  displayname: Export
  description: Export tool
  icon: fa-minus
  url: /data/private/export/
  dashboard_section: Admin
  sidebar_section: Admin
  order: 950
  permission: p_data_export


# Doc
- classname: _home
  keyname: cavaliba
  displayname: Doc Cavaliba (Ext)
  description: Doc Cavaliba
  icon: fa-book
  url: https://cavaliba.com/docs/
  dashboard_section: Other
  sidebar_section: Other
  order: 990
  permission: p_home_access

  




'''

